<?php
require "mediconfig.php";
require "medico.php";
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require dirname(dirname(__FILE__)) . "/vendor/autoload.php";
use Grimzy\LaravelMysqlSpatial\Types\Point;
use Grimzy\LaravelMysqlSpatial\Types\Polygon;
use Grimzy\LaravelMysqlSpatial\Types\LineString;
function siteURL() {
  $protocol = ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') || 
    $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
  $domainName = $_SERVER['HTTP_HOST'];
  return $protocol.$domainName;
}
if (isset($_POST["type"])) {
    if ($_POST["type"] == "login") {
        $username = $_POST["username"];
        $password = $_POST["password"];
        $stype = $_POST["stype"];
        if ($stype == "mowner") {
            $h = new Medico();

            $count = $h->medilogin($username, $password, "admin");
            if ($count != 0) {
                $_SESSION["mediname"] = $username;
                $_SESSION["stype"] = $stype;
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Login Successfully!",
                    "message" => "welcome admin!!",
                    "action" => "dashboard.php",
                ];
            } else {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "false",
                    "title" => "Please Use Valid Data!!",
                    "message" => "Invalid Data!!",
                    "action" => "index.php",
                ];
            }
        }elseif ($stype == "Staff") {
            $h = new Medico();

            $count = $h->medilogin($username, $password, "tbl_staff");
            if ($count != 0) {
                $_SESSION["mediname"] = $username;
                $_SESSION["stype"] = $stype;
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Login Successfully!",
                    "message" => "welcome staff!!",
                    "action" => "dashboard.php",
                ];
            } else {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "false",
                    "title" => "Please Use Valid Data!!",
                    "message" => "Invalid Data!!",
                    "action" => "index.php",
                ];
            }
        } else {
            $h = new Medico();

            $count = $h->medilogin($username, $password, "service_details");
            if ($count != 0) {
                $_SESSION["mediname"] = $username;
                $_SESSION["stype"] = $stype;
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Login Successfully!",
                    "message" => "welcome Store Owner!!",
                    "action" => "dashboard.php",
                ];
            } else {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "false",
                    "title" => "Please Use Valid Data!!",
                    "message" => "Invalid Data!!",
                    "action" => "index.php",
                ];
            }
        }
    } elseif ($_POST["type"] == "update_status") {
        $id = $_POST["id"];
        $status = $_POST["status"];
        $coll_type = $_POST["coll_type"];
        $page_name = $_POST["page_name"];
        if ($coll_type == "subcat") {
            $table = "tbl_subcategory";
            $field = "is_approve=" . $status . "";
            $where = "where id=" . $id . "";
            $h = new Medico();
            $check = $h->mediupdateData_single($field, $table, $where);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Subcategory Status Change Successfully!!",
                    "message" => "Subcategory section!",
                    "action" => "list_store.php",
                ];
            } 
        } elseif ($coll_type == "shopstatus") {
            $table = "service_details";
            $field = "rstatus=" . $status . "";
            $where = "where id=" . $id . "";
            $h = new Medico();
            $check = $h->mediupdateData_single($field, $table, $where);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Shop Status Change Successfully!!",
                    "message" => "Shop section!",
                    "action" => "dashboard.php",
                ];
            } 
        }elseif ($coll_type == "orderapprove") {
            
			$table = "tbl_order";
                $field = [
                    "a_status" => $status,
                    "order_status" => 1,
					"o_status"=>'Processing'
                ];
                $where =
                    "where id=" . $id . "";
                $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);
				
				$checks = $medi->query("select uid from tbl_order where id=".$id."")->fetch_assoc(); 
		   $uid = $checks['uid'];
			$udata = $medi->query("select * from tbl_user where id=".$checks['uid']."")->fetch_assoc();
$name = $udata['name'];

	  
	  
	   
$content = array(
       "en" => $name.', Your Order #'.$id.' Has Been Confirmed.'
   );
$heading = array(
   "en" => "Order Confirmed!!"
);

$fields = array(
'app_id' => $set['one_key'],
'included_segments' =>  array("Active Users"),
'data' => array("order_id" =>$id),
'filters' => array(array('field' => 'tag', 'key' => 'user_id', 'relation' => '=', 'value' => $checks['uid'])),
'contents' => $content,
'headings' => $heading,
'big_picture' => siteURL().'/eatggy/order_process_img/confirmed.png'
);

$fields = json_encode($fields);

 
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
curl_setopt($ch, CURLOPT_HTTPHEADER, 
array('Content-Type: application/json; charset=utf-8',
'Authorization: Basic '.$set['one_hash']));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
curl_setopt($ch, CURLOPT_HEADER, FALSE);
curl_setopt($ch, CURLOPT_POST, TRUE);
curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
 
$response = curl_exec($ch);
curl_close($ch);

$timestamp = date("Y-m-d H:i:s");

$title_main = "Order Confirmed!!";
$description = $name.', Your Order #'.$id.' Has Been Confirmed.';

$table="tbl_notification";
  $field_values=array("uid","datetime","title","description");
  $data_values=array("$uid","$timestamp","$title_main","$description");
  
      $h = new Medico();
	   $h->mediinsertdata_Api($field_values,$data_values,$table);
				
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Order Approved Successfully!!",
                    "message" => "Order section!",
                    "action" => "pending.php",
                ];
            } 
        }elseif ($coll_type == "ordercomplete") {
            
			$table = "tbl_order";
                $field = [
                    "o_status" => 'Completed',
                    "order_status" => $status
                ];
                $where =
                    "where id=" . $id . "";
                $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);
				
				$checks = $medi->query("select uid from tbl_order where id=".$id."")->fetch_assoc(); 
				$uid = $checks['uid'];
			$udata = $medi->query("select * from tbl_user where id=".$checks['uid']."")->fetch_assoc();
$name = $udata['name'];

	  
	  
	   
$content = array(
       "en" => $name.', Your  Order #'.$id.' Has Been Completed.'
   );
$heading = array(
   "en" => "Order Completed!!"
);

$fields = array(
'app_id' => $set['one_key'],
'included_segments' =>  array("Active Users"),
'data' => array("order_id" =>$id),
'filters' => array(array('field' => 'tag', 'key' => 'user_id', 'relation' => '=', 'value' => $checks['uid'])),
'contents' => $content,
'headings' => $heading,
'big_picture' => siteURL().'/eatggy/order_process_img/confirmed.png'
);

$fields = json_encode($fields);

 
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
curl_setopt($ch, CURLOPT_HTTPHEADER, 
array('Content-Type: application/json; charset=utf-8',
'Authorization: Basic '.$set['one_hash']));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
curl_setopt($ch, CURLOPT_HEADER, FALSE);
curl_setopt($ch, CURLOPT_POST, TRUE);
curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
 
$response = curl_exec($ch);
curl_close($ch);

$timestamp = date("Y-m-d H:i:s");

$title_main = "Order Completed!!";
$description = $name.', Your  Order #'.$id.' Has Been Completed.';

$table="tbl_notification";
  $field_values=array("uid","datetime","title","description");
  $data_values=array("$uid","$timestamp","$title_main","$description");
  
      $h = new Medico();
	   $h->mediinsertdata_Api($field_values,$data_values,$table);
	   
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Order Completed Successfully!!",
                    "message" => "Order section!",
                    "action" => "pending.php",
                ];
            } 
        }
		elseif ($coll_type == "porderapprove") {
            
			$table = "tbl_prescription";
                $field = [
                    "a_status" => $status,
                    "order_status" => 1,
					"p_status"=>'Processing'
                ];
                $where =
                    "where id=" . $id . "";
                $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);
				
				$checks = $medi->query("select uid from tbl_prescription where id=".$id."")->fetch_assoc(); 
		   $uid = $checks['uid'];
			$udata = $medi->query("select * from tbl_user where id=".$checks['uid']."")->fetch_assoc();
$name = $udata['name'];

	  
	  
	   
$content = array(
       "en" => $name.', Your Prescription Order #'.$id.' Has Been Confirmed.'
   );
$heading = array(
   "en" => "Prescription Order Confirmed!!"
);

$fields = array(
'app_id' => $set['one_key'],
'included_segments' =>  array("Active Users"),
'data' => array("order_id" =>$id),
'filters' => array(array('field' => 'tag', 'key' => 'user_id', 'relation' => '=', 'value' => $checks['uid'])),
'contents' => $content,
'headings' => $heading,
'big_picture' => siteURL().'/eatggy/order_process_img/confirmed.png'
);

$fields = json_encode($fields);

 
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
curl_setopt($ch, CURLOPT_HTTPHEADER, 
array('Content-Type: application/json; charset=utf-8',
'Authorization: Basic '.$set['one_hash']));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
curl_setopt($ch, CURLOPT_HEADER, FALSE);
curl_setopt($ch, CURLOPT_POST, TRUE);
curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
 
$response = curl_exec($ch);
curl_close($ch);

$timestamp = date("Y-m-d H:i:s");

$title_main = "Prescription Order Confirmed!!";
$description = $name.', Your Prescription Order #'.$id.' Has Been Confirmed.';

$table="tbl_notification";
  $field_values=array("uid","datetime","title","description");
  $data_values=array("$uid","$timestamp","$title_main","$description");
  
      $h = new Medico();
	   $h->mediinsertdata_Api($field_values,$data_values,$table);
				
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Order Approved Successfully!!",
                    "message" => "Order section!",
                    "action" => "pporder.php",
                ];
            } 
        }elseif ($coll_type == "pordercomplete") {
            
			$table = "tbl_prescription";
                $field = [
                    "p_status" => 'Completed',
                    "order_status" => $status
                ];
                $where =
                    "where id=" . $id . "";
                $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);
				
				$checks = $medi->query("select uid from tbl_prescription where id=".$id."")->fetch_assoc(); 
				$uid = $checks['uid'];
			$udata = $medi->query("select * from tbl_user where id=".$checks['uid']."")->fetch_assoc();
$name = $udata['name'];

	  
	  
	   
$content = array(
       "en" => $name.', Your Prescription Order #'.$id.' Has Been Completed.'
   );
$heading = array(
   "en" => "Prescription Order Completed!!"
);

$fields = array(
'app_id' => $set['one_key'],
'included_segments' =>  array("Active Users"),
'data' => array("order_id" =>$id),
'filters' => array(array('field' => 'tag', 'key' => 'user_id', 'relation' => '=', 'value' => $checks['uid'])),
'contents' => $content,
'headings' => $heading,
'big_picture' => siteURL().'/eatggy/order_process_img/confirmed.png'
);

$fields = json_encode($fields);

 
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
curl_setopt($ch, CURLOPT_HTTPHEADER, 
array('Content-Type: application/json; charset=utf-8',
'Authorization: Basic '.$set['one_hash']));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
curl_setopt($ch, CURLOPT_HEADER, FALSE);
curl_setopt($ch, CURLOPT_POST, TRUE);
curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
 
$response = curl_exec($ch);
curl_close($ch);

$timestamp = date("Y-m-d H:i:s");

$title_main = "Prescription Order Completed!!";
$description = $name.', Your Prescription Order #'.$id.' Has Been Completed.';

$table="tbl_notification";
  $field_values=array("uid","datetime","title","description");
  $data_values=array("$uid","$timestamp","$title_main","$description");
  
      $h = new Medico();
	   $h->mediinsertdata_Api($field_values,$data_values,$table);
				
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Order Completed Successfully!!",
                    "message" => "Order section!",
                    "action" => "pporder.php",
                ];
            } 
        }
		elseif ($coll_type == "userstatus") {
            $table = "tbl_user";
            $field = "status=" . $status . "";
            $where = "where id=" . $id . "";
            $h = new Medico();
            $check = $h->mediupdateData_single($field, $table, $where);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "User Status Change Successfully!!",
                    "message" => "User section!",
                    "action" => "userlist.php",
                ];
            } 
        }elseif ($coll_type == "cartdone") {
			
			$table = "tbl_prescription";
                $field = [
                    "setcart" => $status,
                    "order_status" => 3
                ];
                $where =
                    "where id=" . $id . "";
                $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);
				
				$checks = $medi->query("select uid from tbl_prescription where id=".$id."")->fetch_assoc(); 
$uid = $checks['uid'];
			$udata = $medi->query("select * from tbl_user where id=".$checks['uid']."")->fetch_assoc();
$name = $udata['name'];

	  
	  
	   
$content = array(
       "en" => $name.', Your Prescription Order #'.$id.' Cart Has Been Ready.'
   );
$heading = array(
   "en" => "Cart Ready Please Check!!"
);

$fields = array(
'app_id' => $set['one_key'],
'included_segments' =>  array("Active Users"),
'data' => array("order_id" =>$id),
'filters' => array(array('field' => 'tag', 'key' => 'user_id', 'relation' => '=', 'value' => $checks['uid'])),
'contents' => $content,
'headings' => $heading,
'big_picture' => siteURL().'/eatggy/order_process_img/confirmed.png'
);

$fields = json_encode($fields);

 
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
curl_setopt($ch, CURLOPT_HTTPHEADER, 
array('Content-Type: application/json; charset=utf-8',
'Authorization: Basic '.$set['one_hash']));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
curl_setopt($ch, CURLOPT_HEADER, FALSE);
curl_setopt($ch, CURLOPT_POST, TRUE);
curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
 
$response = curl_exec($ch);
curl_close($ch);

$timestamp = date("Y-m-d H:i:s");

$title_main = "Cart Ready Please Check!!";
$description = $name.', Your Prescription Order #'.$id.' Cart Has Been Ready.';

$table="tbl_notification";
  $field_values=array("uid","datetime","title","description");
  $data_values=array("$uid","$timestamp","$title_main","$description");
  
      $h = new Medico();
	   $h->mediinsertdata_Api($field_values,$data_values,$table);
	   
	   
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Cart Done Successfully!!",
                    "message" => "Cart section!",
                    "action" => "pporder.php",
                ];
            } 
        } elseif ($coll_type == "dark_mode") {
            $table = "tbl_setting";
            $field = "show_dark=" . $status . "";
            $where = "where id=" . $id . "";
            $h = new Medico();
            $check = $h->mediupdateData_single($field, $table, $where);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Dark Mode Status Change Successfully!!",
                    "message" => "Dark Mode section!",
                    "action" => $page_name,
                ];
            } 
        } elseif ($coll_type == "service") {
            $table = "tbl_service";
            $field = "is_approve=" . $status . "";
            $where = "where id=" . $id . "";
            $h = new Medico();
            $check = $h->mediupdateData_single($field, $table, $where);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Service Status Change Successfully!!",
                    "message" => "Service section!",
                    "action" => "list_store.php",
                ];
            } 
        } else {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "false",
                "title" => "Option Not There!!",
                "message" => "Error!!",
                "action" => "dashboard.php",
            ];
        }
    } elseif ($_POST["type"] == "customer_notification") {
    // Sanitize input
    $ntitle = $medi->real_escape_string($_POST['ntitle']);
    $nmessage = $medi->real_escape_string($_POST['nmessage']);
    $nurl = $_POST['nurl'];
    $key = $set['one_key'];
    $hash = $set['one_hash'];
    $cat_id = $_POST['cat_id'];
    
    // Prepare content and heading arrays
    $content = array("en" => $nmessage);
    $heading = array("en" => $ntitle);

    // Function to create fields array
    function createFields($key, $content, $heading, $nurl = '', $cat_id = 0) {
        $fields = array(
            'app_id' => $key,
            'included_segments' => array("All"),
            'contents' => $content,
            'headings' => $heading
        );
        
        if ($nurl != '') {
            $fields['big_picture'] = $nurl;
        }
        
        if ($cat_id != 0) {
            $fields['filters'] = array(
                array('field' => 'tag', 'key' => 'user_id', 'relation' => '=', 'value' => $cat_id)
            );
        }
        
        return json_encode($fields);
    }
    
    // Create the fields array
    $fields = createFields($key, $content, $heading, $nurl, $cat_id);
    
    // Initialize cURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json; charset=utf-8',
        'Authorization: Basic ' . $hash
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, FALSE);
    curl_setopt($ch, CURLOPT_POST, TRUE);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

    // Execute cURL and handle response
    $response = curl_exec($ch);
    curl_close($ch);

    // Return response
    $returnArr = array(
        "ResponseCode" => "200", 
        "Result" => "true", 
        "title" => "Notification Send Successfully!!", 
        "message" => "Notification section!", 
        "action" => "push_notification.php"
    );
}

elseif ($_POST["type"] == "store_notification") {
    // Sanitize input
    $ntitle = $medi->real_escape_string($_POST['ntitle']);
    $nmessage = $medi->real_escape_string($_POST['nmessage']);
    $nurl = $_POST['nurl'];
    $key = $set['s_key'];
    $hash = $set['s_hash'];
    $cat_id = $_POST['cat_id'];
    
    // Prepare content and heading arrays
    $content = array("en" => $nmessage);
    $heading = array("en" => $ntitle);

    // Function to create fields array
    function createFields($key, $content, $heading, $nurl = '', $cat_id = 0) {
        $fields = array(
            'app_id' => $key,
            'included_segments' => array("All"),
            'contents' => $content,
            'headings' => $heading
        );
        
        if ($nurl != '') {
            $fields['big_picture'] = $nurl;
        }
        
        if ($cat_id != 0) {
            $fields['filters'] = array(
                array('field' => 'tag', 'key' => 'store_id', 'relation' => '=', 'value' => $cat_id)
            );
        }
        
        return json_encode($fields);
    }
    
    // Create the fields array
    $fields = createFields($key, $content, $heading, $nurl, $cat_id);
    
    // Initialize cURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json; charset=utf-8',
        'Authorization: Basic ' . $hash
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, FALSE);
    curl_setopt($ch, CURLOPT_POST, TRUE);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

    // Execute cURL and handle response
    $response = curl_exec($ch);
    curl_close($ch);

    // Return response
    $returnArr = array(
        "ResponseCode" => "200", 
        "Result" => "true", 
        "title" => "Notification Send Successfully!!", 
        "message" => "Notification section!", 
        "action" => "push_notification.php"
    );
}


elseif ($_POST["type"] == "rider_notification") {
    // Sanitize input
    $ntitle = $medi->real_escape_string($_POST['ntitle']);
    $nmessage = $medi->real_escape_string($_POST['nmessage']);
    $nurl = $_POST['nurl'];
    $key = $set['d_key'];
    $hash = $set['d_hash'];
    $cat_id = $_POST['cat_id'];
    
    // Prepare content and heading arrays
    $content = array("en" => $nmessage);
    $heading = array("en" => $ntitle);

    // Function to create fields array
    function createFields($key, $content, $heading, $nurl = '', $cat_id = 0) {
        $fields = array(
            'app_id' => $key,
            'included_segments' => array("All"),
            'contents' => $content,
            'headings' => $heading
        );
        
        if ($nurl != '') {
            $fields['big_picture'] = $nurl;
        }
        
        if ($cat_id != 0) {
            $fields['filters'] = array(
                array('field' => 'tag', 'key' => 'rider_id', 'relation' => '=', 'value' => $cat_id)
            );
        }
        
        return json_encode($fields);
    }
    
    // Create the fields array
    $fields = createFields($key, $content, $heading, $nurl, $cat_id);
    
    // Initialize cURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json; charset=utf-8',
        'Authorization: Basic ' . $hash
    ));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, FALSE);
    curl_setopt($ch, CURLOPT_POST, TRUE);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

    // Execute cURL and handle response
    $response = curl_exec($ch);
    curl_close($ch);

    // Return response
    $returnArr = array(
        "ResponseCode" => "200", 
        "Result" => "true", 
        "title" => "Notification Send Successfully!!", 
        "message" => "Notification section!", 
        "action" => "push_notification.php"
    );
}

elseif ($_POST["type"] == "add_staff") {
$banner = isset($_POST["banner"]) ? implode(',', $_POST["banner"]) : "";
$category = isset($_POST["category"]) ? implode(',', $_POST["category"]) : "";
$store = isset($_POST["store"]) ? implode(',', $_POST["store"]) : "";
$zone = isset($_POST["zone"]) ? implode(',', $_POST["zone"]) : "";
$payout = isset($_POST["payout"]) ? implode(',', $_POST["payout"]) : "";
$page = isset($_POST["page"]) ? implode(',', $_POST["page"]) : "";
$ulist = isset($_POST["ulist"]) ? implode(',', $_POST["ulist"]) : "";
$payment = isset($_POST["payment"]) ? implode(',', $_POST["payment"]) : "";
$email = $_POST["email"];
$password = $_POST["password"];
$status = $_POST["status"];

$table = "tbl_staff";
            $field_values = ["banner","category","zone", "status", "password","page","payout","payment","ulist","email","store"];
            $data_values = ["$banner","$category","$zone", "$status", "$password","$page","$payout","$payment","$ulist","$email","$store"];

            $h = new Medico();
            $check = $h->mediinsertdata($field_values, $data_values, $table);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Staff Add Successfully!!",
                    "message" => "Staff section!",
                    "action" => "list_staff.php",
                ];
            } 
			
}

elseif ($_POST["type"] == "edit_staff") {
$banner = isset($_POST["banner"]) ? implode(',', $_POST["banner"]) : "";
$category = isset($_POST["category"]) ? implode(',', $_POST["category"]) : "";
$store = isset($_POST["store"]) ? implode(',', $_POST["store"]) : "";
$zone = isset($_POST["zone"]) ? implode(',', $_POST["zone"]) : "";
$payout = isset($_POST["payout"]) ? implode(',', $_POST["payout"]) : "";
$page = isset($_POST["page"]) ? implode(',', $_POST["page"]) : "";
$ulist = isset($_POST["ulist"]) ? implode(',', $_POST["ulist"]) : "";
$payment = isset($_POST["payment"]) ? implode(',', $_POST["payment"]) : "";
$email = $_POST["email"];
$password = $_POST["password"];
$status = $_POST["status"];
$id = $_POST["id"];

$table = "tbl_staff";
                $field = ["banner"=>$banner,"store"=>$store,"category"=>$category,"status" => $status, "zone" => $zone,"page"=>$page, "payout" => $payout,"payment"=>$payment,"ulist"=>$ulist,"email"=>$email,"password"=>$password];
                $where = "where id=" . $id . "";
                 $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);
				
if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Staff Update Successfully!!",
                    "message" => "Staff section!",
                    "action" => "list_staff.php",
                ];
            } 
			
}elseif ($_POST["type"] == "add_timeslot") {
        $cat_id = $_POST["category"];

        $day_type = $_POST["dthing"];
        $total_days = $_POST["day"];
        $timeslot = implode(",", $_POST["timsloat"]);
        $vendor_id = $sdata["id"];
        $table = "tbl_timeslot";
        $check_exist = $medi->query(
            "select * from tbl_timeslot where cat_id=" .
                $cat_id .
                " and vendor_id=" .
                $vendor_id .
                ""
        )->num_rows;
        if ($check_exist != 0) {
            $returnArr = [
                "ResponseCode" => "401",
                "Result" => "false",
                "title" => "Timeslot Already Added In Category!",
                "message" => "Timeslot section!",
                "action" => "list_Timeslot.php",
            ];
        } else {
            $field_values = [
                "cat_id",
                "vendor_id",
                "day_type",
                "total_days",
                "timeslot",
            ];
            $data_values = [
                "$cat_id",
                "$vendor_id",
                "$day_type",
                "$total_days",
                "$timeslot",
            ];

            $h = new Medico();
            $check = $h->mediinsertdata($field_values, $data_values, $table);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Timeslot Add Successfully!!",
                    "message" => "Timeslot section!",
                    "action" => "list_Timeslot.php",
                ];
            } 
        }
    }elseif($_POST["type"] =="assign_rider")
	{
		$rid = $_POST['srider'];
		$id = $_POST["id"];
		$check = $medi->query("select order_status from tbl_order where id=".$id."")->fetch_assoc();
		if($check['order_status'] != 4)
						{
						$table="tbl_order";
  $field = array('rid'=>$rid,'order_status'=>3);
  $where = "where id=".$id."";
$h = new Medico();
	  $check = $h->mediupdateData($field,$table,$where);
	  if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Rider  Assign Successfully!!",
                        "message" => "Rider section!",
                        "action" => "pending.php",
                    ];
                } 
						}
						else 
						{
							$returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "false",
                        "title" =>
                            "Assign Delivery Boy Already Accepted Order So Can not Change Delivery Boy!!",
                        "message" => "Rider Section!!",
                        "action" => "pending.php",
                    ];
						}
	}elseif($_POST["type"] =="passign_rider")
	{
		$rid = $_POST['srider'];
		$id = $_POST["id"];
		$check = $medi->query("select order_status from tbl_prescription where id=".$id."")->fetch_assoc();
		if($check['tbl_prescription'] != 7)
						{
						$table="tbl_prescription";
  $field = array('rid'=>$rid,'order_status'=>6);
  $where = "where id=".$id."";
$h = new Medico();
	  $check = $h->mediupdateData($field,$table,$where);
	  if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Rider  Assign Successfully!!",
                        "message" => "Rider section!",
                        "action" => "pporder.php",
                    ];
                } 
						}
						else 
						{
							$returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "false",
                        "title" =>
                            "Assign Delivery Boy Already Accepted Order So Can not Change Delivery Boy!!",
                        "message" => "Rider Section!!",
                        "action" => "pporder.php",
                    ];
						}
	}elseif($_POST["type"] =="set_quantity"){
		$quantity = $_POST['quantity'];
		$id = $_POST["id"];
		$getoid = $medi->query("select oid from tbl_pre_product where id=".$id."")->fetch_assoc();
		$getodata = $medi->query("select c_accept from tbl_prescription where id=".$getoid['oid']."")->fetch_assoc();
		if($getodata['c_accept'] == 1 or $getodata['c_accept'] == 2)
			{
				$returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "false",
                        "title" => "Customer Order accepted Or Rejected So Not Change!!",
                        "message" => "Set Cart Section!!",
                        "action" => "set_cart.php?id=" . $id. "",
                    ];
				
			}
			else 
			{
		$table = "tbl_pre_product";
            $field = "pquantity=" . $quantity . "";
            $where = "where id=" . $id . "";
            $h = new Medico();
            $check = $h->mediupdateData_single($field, $table, $where);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Change Quantity Change Successfully!!",
                    "message" => "User section!",
                    "action" => "set_cart.php?id=".$id."",
                ];
            } 
			}
	}
	elseif($_POST["type"] =="set_cart"){
		
		$pid = $_POST['medicine'];
		$pquantity = $_POST['quantity'];
		$oid = $_POST['id'];
		$pdata = $medi->query("select title,sprice,aprice from tbl_medicine where id=".$pid."")->fetch_assoc();
		$getodata = $medi->query("select c_accept from tbl_prescription where id=".$oid."")->fetch_assoc();
		$ptitle = $pdata['title'];
		$sprice = $pdata['sprice'];
		$pprice = $pdata['aprice'];
		$check_product = $medi->query("select * from tbl_pre_product where pid=".$pid." and oid=".$oid."")->num_rows;
			if($check_product != 0)
			{
				$returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "false",
                        "title" => "Product Already Added Please Check On List Cart Data!!",
                        "message" => "Set Cart Section!!",
                        "action" => "set_cart.php?prid=" . $oid . "",
                    ];
				
			}else if($getodata['c_accept'] == 1 or $getodata['c_accept'] == 2)
			{
				$returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "false",
                        "title" => "Customer Order accepted Or Rejected So Not Change!!",
                        "message" => "Set Cart Section!!",
                        "action" => "set_cart.php?prid=" . $oid . "",
                    ];
				
			}
			else 
			{
				$store_id = $sdata["id"];
			$table="tbl_pre_product";
  $field_values=array("oid","pquantity","ptitle","sprice","pprice","pid","store_id");
  $data_values=array("$oid","$pquantity","$ptitle","$sprice","$pprice","$pid","$store_id");
  $h = new Medico();
                $check = $h->mediinsertdata(
                    $field_values,
                    $data_values,
                    $table
                );
				if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Item Added Successfully!!",
                        "message" => "Cart section!",
                        "action" => "set_cart.php?prid=" . $oid . "",
                    ];
                } 
			}
		
	}elseif($_POST["type"] =="cancle_order")
	{
		$c_reason = $medi->real_escape_string($_POST['c_reason']);
		$id = $_POST["id"];
		
						$table="tbl_order";
  $field = array('comment_reject'=>$c_reason,'order_status'=>2,'a_status'=>2,'o_status'=>'Cancelled');
  $where = "where id=".$id."";
$h = new Medico();
	  $check = $h->mediupdateData($field,$table,$where);
	  
	  $checks = $medi->query("select uid from tbl_order where id=".$id."")->fetch_assoc(); 
		 $uid = $checks['uid'];
			$udata = $medi->query("select * from tbl_user where id=".$checks['uid']."")->fetch_assoc();
$name = $udata['name'];

	  
	  
	   
$content = array(
       "en" => $name.', Your Order #'.$id.' Has Been Rejected.'
   );
$heading = array(
   "en" => $comment_reject
);

$fields = array(
'app_id' => $set['one_key'],
'included_segments' =>  array("Active Users"),
'data' => array("order_id" =>$id),
'filters' => array(array('field' => 'tag', 'key' => 'user_id', 'relation' => '=', 'value' => $checks['uid'])),
'contents' => $content,
'headings' => $heading,
'big_picture' => siteURL().'/eatggy/order_process_img/confirmed.png'
);

$fields = json_encode($fields);

 
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
curl_setopt($ch, CURLOPT_HTTPHEADER, 
array('Content-Type: application/json; charset=utf-8',
'Authorization: Basic '.$set['one_hash']));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
curl_setopt($ch, CURLOPT_HEADER, FALSE);
curl_setopt($ch, CURLOPT_POST, TRUE);
curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
 
$response = curl_exec($ch);
curl_close($ch);

$timestamp = date("Y-m-d H:i:s");
$description = $name.', Your Order #'.$id.' Has Been Rejected.';

$table="tbl_notification";
  $field_values=array("uid","datetime","title","description");
  $data_values=array("$uid","$timestamp","$comment_reject","$description");
  
      $h = new Medico();
	   $h->mediinsertdata_Api($field_values,$data_values,$table); 
	   
	   
	  if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Order Cancelled Successfully!!",
                        "message" => "Order section!",
                        "action" => "cancle.php",
                    ];
                } 
	}elseif($_POST["type"] =="pcancle_order")
	{
		$c_reason = $medi->real_escape_string($_POST['c_reason']);
		$id = $_POST["id"];
		
						$table="tbl_prescription";
  $field = array('comment_reject'=>$c_reason,'order_status'=>2,'a_status'=>2,'p_status'=>'Cancelled');
  $where = "where id=".$id."";
$h = new Medico();
	  $check = $h->mediupdateData($field,$table,$where);
	  
	  $checks = $medi->query("select uid from tbl_prescription where id=".$id."")->fetch_assoc(); 
		 $uid = $checks['uid'];
			$udata = $medi->query("select * from tbl_user where id=".$checks['uid']."")->fetch_assoc();
$name = $udata['name'];

	  
	  
	   
$content = array(
       "en" => $name.', Your Prescription Order #'.$id.' Has Been Rejected.'
   );
$heading = array(
   "en" => $comment_reject
);

$fields = array(
'app_id' => $set['one_key'],
'included_segments' =>  array("Active Users"),
'data' => array("order_id" =>$id),
'filters' => array(array('field' => 'tag', 'key' => 'user_id', 'relation' => '=', 'value' => $checks['uid'])),
'contents' => $content,
'headings' => $heading,
'big_picture' => siteURL().'/eatggy/order_process_img/confirmed.png'
);

$fields = json_encode($fields);

 
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
curl_setopt($ch, CURLOPT_HTTPHEADER, 
array('Content-Type: application/json; charset=utf-8',
'Authorization: Basic '.$set['one_hash']));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
curl_setopt($ch, CURLOPT_HEADER, FALSE);
curl_setopt($ch, CURLOPT_POST, TRUE);
curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
 
$response = curl_exec($ch);
curl_close($ch);

$timestamp = date("Y-m-d H:i:s");
$description = $name.', Your Prescription Order #'.$id.' Has Been Rejected.';

$table="tbl_notification";
  $field_values=array("uid","datetime","title","description");
  $data_values=array("$uid","$timestamp","$comment_reject","$description");
  
      $h = new Medico();
	   $h->mediinsertdata_Api($field_values,$data_values,$table);
	   
	   
	  if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Order Cancelled Successfully!!",
                        "message" => "Order section!",
                        "action" => "cporder.php",
                    ];
                } 
	}
	  elseif ($_POST["type"] == "add_banner") {
        $okey = $_POST["status"];
		$store_id = $_POST["store_id"];
        $target_dir = dirname(dirname(__FILE__)) . "/images/banner/";
        $url = "images/banner/";
        $temp = explode(".", $_FILES["cat_img"]["name"]);
        $newfilename = round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);
        
            move_uploaded_file($_FILES["cat_img"]["tmp_name"], $target_file);
            $table = "banner";
            $field_values = ["img", "status","store_id"];
            $data_values = ["$url", "$okey","$store_id"];

            $h = new Medico();
            $check = $h->mediinsertdata($field_values, $data_values, $table);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Banner Add Successfully!!",
                    "message" => "banner section!",
                    "action" => "list_banner.php",
                ];
            } 
        
    }elseif ($_POST["type"] == "add_rider") {
        $status = $_POST["status"];
		$title = $medi->real_escape_string($_POST['title']);
		$email = $_POST["email"];
		$ccode = $_POST["ccode"];
		$mobile = $_POST["mobile"];
		$store_id = $sdata["id"];
		$rdate  = date("Y-m-d");
		$password = $medi->real_escape_string($_POST['password']);
        $target_dir = dirname(dirname(__FILE__)) . "/images/rider/";
        $url = "images/rider/";
        $temp = explode(".", $_FILES["cat_img"]["name"]);
        $newfilename = round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);
		$check_details = $medi->query(
            "select email from tbl_rider where email='" . $email . "'"
        )->num_rows;
        if ($check_details != 0) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "false",
                "title" => "Rider Email Already Used!!",
                "message" => "Rider section!",
                "action" => "add_rider.php",
            ];
        } else {
        
            move_uploaded_file($_FILES["cat_img"]["tmp_name"], $target_file);
            $table = "tbl_rider";
            $field_values = ["img", "status","title","email","ccode","mobile","store_id","rdate","password"];
            $data_values = ["$url", "$status","$title","$email","$ccode","$mobile","$store_id","$rdate","$password"];

            $h = new Medico();
            $check = $h->mediinsertdata($field_values, $data_values, $table);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Rider Add Successfully!!",
                    "message" => "Rider section!",
                    "action" => "list_rider.php",
                ];
            } 
        
		}
    }elseif ($_POST["type"] == "edit_rider") {
        $status = $_POST["status"];
		$title = $medi->real_escape_string($_POST['title']);
		$email = $_POST["email"];
		$ccode = $_POST["ccode"];
		$mobile = $_POST["mobile"];
		$store_id = $sdata["id"];
		$id = $_POST["id"];
		$password = $medi->real_escape_string($_POST['password']);
        $target_dir = dirname(dirname(__FILE__)) . "/images/rider/";
        $url = "images/rider/";
        $temp = explode(".", $_FILES["cat_img"]["name"]);
        $newfilename = round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);
		$check_details = $medi->query(
            "select email from tbl_rider where email='" .
                $email .
                "' and id!=" .
                $id .
                ""
        )->num_rows;
        if ($check_details != 0) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "false",
                "title" => "Rider Email Already Used!!",
                "message" => "Rider section!",
                "action" => "add_rider.php?id=" . $id . "",
            ];
        } else {
        if ($_FILES["cat_img"]["name"] != "") {
            
                move_uploaded_file(
                    $_FILES["cat_img"]["tmp_name"],
                    $target_file
                );
                $table = "tbl_rider";
                $field = ["status" => $status, "img" => $url,"title"=>$title,"email"=>$email,"ccode"=>$ccode,"mobile"=>$mobile,"password"=>$password];
                $where = "where id=" . $id . " and store_id=".$store_id."";
                $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);

                if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Rider Update Successfully!!",
                        "message" => "Rider section!",
                        "action" => "list_rider.php",
                    ];
                } 
            
    } else {
            $table = "tbl_rider";
                $field = ["status" => $status,"title"=>$title,"email"=>$email,"ccode"=>$ccode,"mobile"=>$mobile,"password"=>$password];
                $where = "where id=" . $id . " and store_id=".$store_id."";
                $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);

            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Rider Update Successfully!!",
                    "message" => "Rider section!",
                    "action" => "list_rider.php",
                ];
            } 
        }
		}
	}elseif ($_POST["type"] == "add_gallery") {
        $okey = $_POST["status"];
		$store_id = $sdata["id"];
        $target_dir = dirname(dirname(__FILE__)) . "/images/gallery/";
        $url = "images/gallery/";
        $temp = explode(".", $_FILES["cat_img"]["name"]);
        $newfilename = round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);
        
            move_uploaded_file($_FILES["cat_img"]["tmp_name"], $target_file);
            $table = "tbl_photo";
            $field_values = ["img", "status","store_id"];
            $data_values = ["$url", "$okey","$store_id"];

            $h = new Medico();
            $check = $h->mediinsertdata($field_values, $data_values, $table);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Photo Add Successfully!!",
                    "message" => "Photo section!",
                    "action" => "list_photo.php",
                ];
            } 
        
    }elseif ($_POST["type"] == "add_extra") {
        $okey = $_POST["status"];
		$store_id = $sdata["id"];
		$mid = $_POST["mid"];
        $target_dir = dirname(dirname(__FILE__)) . "/images/gallery/";
        $url = "images/gallery/";
        $temp = explode(".", $_FILES["cat_img"]["name"]);
        $newfilename = uniqid().round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);
        
            move_uploaded_file($_FILES["cat_img"]["tmp_name"], $target_file);
            $table = "tbl_extra";
            $field_values = ["img", "status","store_id","mid"];
            $data_values = ["$url", "$okey","$store_id","$mid"];

            $h = new Medico();
            $check = $h->mediinsertdata($field_values, $data_values, $table);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Extra Image Add Successfully!!",
                    "message" => "Extra Image section!",
                    "action" => "list_extra.php",
                ];
            } 
        
    }
	elseif ($_POST["type"] == "import_medicine") {
    $store_id = $sdata["id"];
    if ($_FILES['csv']['error'] == 0) {
        $name = $_FILES['csv']['name'];
        $arrayVar = explode(".", $name);
        $ext = end($arrayVar);
        $type = $_FILES['csv']['type'];
        $tmpName = $_FILES['csv']['tmp_name'];

        // Check if the file is a CSV
        if ($ext === 'csv') {
            if (($handle = fopen($tmpName, 'r')) !== FALSE) {
                // Necessary if a large CSV file
                set_time_limit(0);

                // Skip the first line (headers)
                fgets($handle);

                // Prepare the timestamp
                date_default_timezone_set('Asia/Kolkata');
                $timestamp = date("Y-m-d");

                while (($data = fgetcsv($handle, 1000, ',')) !== FALSE) {
                    // Get the number of fields in the CSV
                    $col_count = count($data);

                    // Check if the required number of columns are present
                    if ($col_count < 10) {
                        continue; // Skip if columns are less than expected
                    }

                    // Check if the medicine already exists
                    $counts = $medi->query("SELECT * FROM tbl_medicine WHERE title='" . $data[6] . "'")->num_rows;
                    if ($counts == 0) {
                        $table = "tbl_medicine";
                        $field_values = ["img", "status", "sprice", "aprice", "qlimit", "store_id", "is_require", "title", "description", "disclaimer", "cat_id"];
                        $data_values = [$data[0], $data[4], $data[3], $data[2], $data[5], $store_id, $data[6], $data[1], $data[8], $data[9], $data[7]];

                        $h = new Medico();
                        $check = $h->mediinsertdata($field_values, $data_values, $table);
                        if ($check == 1) {
                            $returnArr = [
                                "ResponseCode" => "200",
                                "Result" => "true",
                                "title" => "Medicine Import Successfully!!",
                                "message" => "Medicine section!",
                                "action" => "medicine_import.php",
                            ];
                        } 
                    }
                }
                fclose($handle);
            } else {
                // Error opening the file
                $returnArr = [
                    "ResponseCode" => "500",
                    "Result" => "false",
                    "title" => "Unable to open the CSV file.",
                    "message" => "Unable to open the CSV file.",
                    "action" => "medicine_import.php",
                ];
            }
        } else {
            // Invalid file type
            $returnArr = [
                "ResponseCode" => "400",
                "Result" => "false",
                "title" => "Please upload a CSV file.",
                "message" => "Please upload a CSV file.",
                "action" => "medicine_import.php",
            ];
        }
    } else {
        // File upload error
        $returnArr = [
            "ResponseCode" => "400",
            "Result" => "false",
            "title" => "File Upload Error",
            "message" => "There was an error uploading the file.",
            "action" => "medicine_import.php",
        ];
    }
    
}

	elseif ($_POST["type"] == "add_medicine") {
        $status = $_POST["status"];
		$aprice = $_POST["aprice"];
		$sprice = $_POST["sprice"];
		$qlimit = $_POST["qlimit"];
		$cat_id = $_POST["cat_id"];
		$is_require = $_POST["is_require"];
		$title = $medi->real_escape_string($_POST["title"]);
		$description = $medi->real_escape_string($_POST["description"]);
		$disclaimer = $medi->real_escape_string($_POST["disclaimer"]);
		$store_id = $sdata["id"];
        $target_dir = dirname(dirname(__FILE__)) . "/images/medicine/";
        $url = "images/medicine/";
        $temp = explode(".", $_FILES["medicine_img"]["name"]);
        $newfilename = round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);
        
            move_uploaded_file($_FILES["medicine_img"]["tmp_name"], $target_file);
            $table = "tbl_medicine";
            $field_values = ["img", "status","sprice","aprice","qlimit","store_id","is_require","title","description","disclaimer","cat_id"];
            $data_values = ["$url", "$status","$sprice","$aprice","$qlimit","$store_id","$is_require","$title","$description","$disclaimer","$cat_id"];

            $h = new Medico();
            $check = $h->mediinsertdata($field_values, $data_values, $table);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Medicine Add Successfully!!",
                    "message" => "Medicine section!",
                    "action" => "list_medi.php",
                ];
            } 
        
    }
	elseif ($_POST["type"] == "edit_medicine") {
        $status = $_POST["status"];
		$id = $_POST["id"];
		$aprice = $_POST["aprice"];
		$sprice = $_POST["sprice"];
		$qlimit = $_POST["qlimit"];
		$cat_id = $_POST["cat_id"];
		$is_require = $_POST["is_require"];
		$title = $medi->real_escape_string($_POST["title"]);
		$description = $medi->real_escape_string($_POST["description"]);
		$disclaimer = $medi->real_escape_string($_POST["disclaimer"]);
		$store_id = $sdata["id"];
        $target_dir = dirname(dirname(__FILE__)) . "/images/medicine/";
        $url = "images/medicine/";
        $temp = explode(".", $_FILES["medicine_img"]["name"]);
        $newfilename = round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);
         if ($_FILES["medicine_img"]["name"] != "") {
           
                move_uploaded_file(
                    $_FILES["medicine_img"]["tmp_name"],
                    $target_file
                );
                $table = "tbl_medicine";
                $field = ["status" => $status, "img" => $url,"aprice"=>$aprice,"sprice"=>$sprice,"qlimit"=>$qlimit,"cat_id"=>$cat_id,"is_require"=>$is_require,"title"=>$title,"description"=>$description,"disclaimer"=>$disclaimer];
                $where = "where id=" . $id . " and store_id=".$store_id."";
                $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);

                if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Medicine Update Successfully!!",
                        "message" => "Medicine section!",
                        "action" => "list_medi.php",
                    ];
                } 
            
        } else {
            $table = "tbl_medicine";
                $field = ["status" => $status,"aprice"=>$aprice,"sprice"=>$sprice,"qlimit"=>$qlimit,"cat_id"=>$cat_id,"is_require"=>$is_require,"title"=>$title,"description"=>$description,"disclaimer"=>$disclaimer];
                $where = "where id=" . $id . " and store_id=".$store_id."";
                $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Medicine Update Successfully!!",
                    "message" => "Medicine section!",
                    "action" => "list_medi.php",
                ];
            } 
        }
    }
	elseif ($_POST["type"] == "add_section_item") {
        $okey = $_POST["status"];
        $catsearch = $_POST["catsearch"];
        $title = $medi->real_escape_string($_POST["title"]);
        $target_dir = dirname(dirname(__FILE__)) . "/images/section/";
        $url = "images/section/";
        $temp = explode(".", $_FILES["cat_img"]["name"]);
        $newfilename = round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);
        
            move_uploaded_file($_FILES["cat_img"]["tmp_name"], $target_file);
            $table = "section_item";
            $field_values = ["img", "status", "title", "section_id"];
            $data_values = ["$url", "$okey", "$title", "$catsearch"];

            $h = new Medico();
            $check = $h->mediinsertdata($field_values, $data_values, $table);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Section Item Add Successfully!!",
                    "message" => "Section Item section!",
                    "action" => "list_Section_Item.php",
                ];
            } 
        
    } elseif ($_POST["type"] == "edit_section_item") {
        $okey = $_POST["status"];
        $catsearch = $_POST["catsearch"];
        $title = $medi->real_escape_string($_POST["title"]);
        $id = $_POST["id"];
        $target_dir = dirname(dirname(__FILE__)) . "/images/section/";
        $url = "images/section/";
        $temp = explode(".", $_FILES["cat_img"]["name"]);
        $newfilename = round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);
        if ($_FILES["cat_img"]["name"] != "") {
            
                move_uploaded_file(
                    $_FILES["cat_img"]["tmp_name"],
                    $target_file
                );
                $table = "section_item";
                $field = [
                    "status" => $okey,
                    "img" => $url,
                    "title" => $title,
                    "section_id" => $catsearch,
                ];
                $where = "where id=" . $id . "";
                $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);

                if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Section Item Update Successfully!!",
                        "message" => "Section Item section!",
                        "action" => "list_Section_Item.php",
                    ];
                } 
            
        } else {
            $table = "section_item";
            $field = [
                "status" => $okey,
                "title" => $title,
                "section_id" => $catsearch,
            ];
            $where = "where id=" . $id . "";
            $h = new Medico();
            $check = $h->mediupdateData($field, $table, $where);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Section Item Update Successfully!!",
                    "message" => "Section Item section!",
                    "action" => "list_Section_Item.php",
                ];
            } 
        }
    } elseif ($_POST["type"] == "add_cover_img") {
        $id = $_POST["id"];
        $count = $medi->query(
            "select * from tbl_cover_images where cover_id=" . $id . ""
        )->num_rows;
        if ($count >= 5) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "false",
                "title" => "Only Allow 5 Images",
                "message" => "Upload Problem!!",
                "action" => "list_Cover.php",
            ];
        } else {
            $target_dir = dirname(dirname(__FILE__)) . "/images/cover/";
            $url = "images/cover/";
            $temp = explode(".", $_FILES["cat_img"]["name"]);
            $newfilename = round(microtime(true)) . "." . end($temp);
            $target_file = $target_dir . basename($newfilename);
            $url = $url . basename($newfilename);
            
                move_uploaded_file(
                    $_FILES["cat_img"]["tmp_name"],
                    $target_file
                );
                $table = "tbl_cover_images";
                $field_values = ["text", "cover_id"];
                $data_values = ["$url", "$id"];

                $h = new Medico();
                $check = $h->mediinsertdata(
                    $field_values,
                    $data_values,
                    $table
                );
                if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Cover Image Update Successfully!!",
                        "message" => "Cover Image section!",
                        "action" => "list_Cover.php",
                    ];
                } 
            
        }
    } elseif ($_POST["type"] == "edit_cover_img") {
        $id = $_POST["id"];
        if ($_FILES["cat_img"]["name"] != "") {
            $target_dir = dirname(dirname(__FILE__)) . "/images/cover/";
            $url = "images/cover/";
            $temp = explode(".", $_FILES["cat_img"]["name"]);
            $newfilename = round(microtime(true)) . "." . end($temp);
            $target_file = $target_dir . basename($newfilename);
            $url = $url . basename($newfilename);
            
                move_uploaded_file(
                    $_FILES["cat_img"]["tmp_name"],
                    $target_file
                );
                $table = "tbl_cover_images";
                $field = ["text" => $url];
                $where = "where id=" . $id . "";
                $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);
                if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Cover Image Update Successfully!!",
                        "message" => "Cover Image section!",
                        "action" => "list_Cover.php",
                    ];
                } 
            
        } else {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "false",
                "title" => "Cover Image Update Successfully!!",
                "message" => "Cover Image Section!!",
                "action" => "list_Cover.php",
            ];
        }
    } elseif ($_POST["type"] == "add_category") {
        $okey = $_POST["status"];
        $title = $medi->real_escape_string($_POST["title"]);
		
		
        $target_dir = dirname(dirname(__FILE__)) . "/images/category/";
        $url = "images/category/";
        $temp = explode(".", $_FILES["cat_img"]["name"]);
        $newfilename = round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);
		
		$target_dirs = dirname(dirname(__FILE__)) . "/images/category/";
        $urls = "images/category/";
        $temps = explode(".", $_FILES["cover_img"]["name"]);
        $newfilenames = uniqid().round(microtime(true)) . "." . end($temps);
        $target_files = $target_dirs. basename($newfilenames);
        $urls = $urls . basename($newfilenames);
		
        
            move_uploaded_file($_FILES["cat_img"]["tmp_name"], $target_file);
			move_uploaded_file($_FILES["cover_img"]["tmp_name"], $target_files);
            $table = "tbl_category";
            $field_values = ["img", "status", "title","cover"];
            $data_values = ["$url", "$okey", "$title","$urls"];

            $h = new Medico();
            $check = $h->mediinsertdata($field_values, $data_values, $table);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Category Add Successfully!!",
                    "message" => "Category section!",
                    "action" => "list_category.php",
                ];
            } 
        
    } elseif ($_POST["type"] == "add_mcat") {
        $okey = $_POST["status"];
        $title = $medi->real_escape_string($_POST["title"]);
		$store_id = $sdata["id"];
		
        
           
            $table = "tbl_mcat";
            $field_values = [ "status", "title","store_id"];
            $data_values = ["$okey", "$title","$store_id"];

            $h = new Medico();
            $check = $h->mediinsertdata($field_values, $data_values, $table);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Menu Category Add Successfully!!",
                    "message" => "Menu Category section!",
                    "action" => "list_mcat.php",
                ];
            } 
        
    }elseif ($_POST["type"] == "com_payout") {
        $payout_id = $_POST["payout_id"];
        $target_dir = dirname(dirname(__FILE__)) . "/images/payout/";
        $url = "images/payout/";
        $temp = explode(".", $_FILES["cat_img"]["name"]);
        $newfilename = round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);
        
            move_uploaded_file($_FILES["cat_img"]["tmp_name"], $target_file);
            $table = "payout_setting";
            $field = ["proof" => $url, "status" => "completed"];
            $where = "where id=" . $payout_id . "";
            $h = new Medico();
            $check = $h->mediupdateData($field, $table, $where);

            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Payout Update Successfully!!",
                    "message" => "Payout section!",
                    "action" => "list_payout.php",
                ];
            } 
        
    } elseif ($_POST["type"] == "add_subcategory") {
        $cat_id = $_POST["cat_id"];
        $vendor_id = $sdata["id"];
        $okey = $_POST["status"];
        $title = $medi->real_escape_string($_POST["title"]);
        $target_dir = dirname(dirname(__FILE__)) . "/images/subcategory/";
        $url = "images/subcategory/";
        $temp = explode(".", $_FILES["cat_img"]["name"]);
        $newfilename = round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);
        
            move_uploaded_file($_FILES["cat_img"]["tmp_name"], $target_file);
            $table = "tbl_subcategory";
            $field_values = ["img", "status", "title", "vendor_id", "cat_id"];
            $data_values = ["$url", "$okey", "$title", "$vendor_id", "$cat_id"];

            $h = new Medico();
            $check = $h->mediinsertdata($field_values, $data_values, $table);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Subcategory Add Successfully!!",
                    "message" => "Subcategory section!",
                    "action" => "list_Subcategory.php",
                ];
            } 
        
    } elseif ($_POST["type"] == "add_coupon") {
        $expire_date = $_POST["expire_date"];
        $store_id = $sdata["id"];
        $status = $_POST["status"];
        $coupon_code = $_POST["coupon_code"];
        $min_amt = $_POST["min_amt"];
        $coupon_val = $_POST["coupon_val"];
        $description = $medi->real_escape_string($_POST["description"]);
        $title = $medi->real_escape_string($_POST["title"]);
        $subtitle = $medi->real_escape_string($_POST["subtitle"]);
        $target_dir = dirname(dirname(__FILE__)) . "/images/coupon/";
        $url = "images/coupon/";
        $temp = explode(".", $_FILES["coupon_img"]["name"]);
        $newfilename = round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);
        
            move_uploaded_file($_FILES["coupon_img"]["tmp_name"], $target_file);
            $table = "tbl_coupon";
            $field_values = [
                "expire_date",
                "status",
                "title",
                "store_id",
                "coupon_code",
                "min_amt",
                "coupon_val",
                "description",
                "subtitle",
                "coupon_img",
            ];
            $data_values = [
                "$expire_date",
                "$status",
                "$title",
                "$store_id",
                "$coupon_code",
                "$min_amt",
                "$coupon_val",
                "$description",
                "$subtitle",
                "$url",
            ];

            $h = new Medico();
            $check = $h->mediinsertdata($field_values, $data_values, $table);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Coupon Add Successfully!!",
                    "message" => "Coupon section!",
                    "action" => "list_coupon.php",
                ];
            } 
        
    } elseif ($_POST["type"] == "edit_coupon") {
        $expire_date = $_POST["expire_date"];
        $vendor_id = $sdata["id"];
        $id = $_POST["id"];
        $status = $_POST["status"];
        $coupon_code = $_POST["coupon_code"];
        $min_amt = $_POST["min_amt"];
        $coupon_val = $_POST["coupon_val"];
        $description = $medi->real_escape_string($_POST["description"]);
        $title = $medi->real_escape_string($_POST["title"]);
        $subtitle = $medi->real_escape_string($_POST["subtitle"]);
        $target_dir = dirname(dirname(__FILE__)) . "/images/coupon/";
        $url = "images/coupon/";
        $temp = explode(".", $_FILES["coupon_img"]["name"]);
        $newfilename = round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);
        if ($_FILES["coupon_img"]["name"] != "") {
            
                move_uploaded_file(
                    $_FILES["coupon_img"]["tmp_name"],
                    $target_file
                );
                $table = "tbl_coupon";
                $field = [
                    "status" => $status,
                    "coupon_img" => $url,
                    "title" => $title,
                    "coupon_code" => $coupon_code,
                    "min_amt" => $min_amt,
                    "coupon_val" => $coupon_val,
                    "description" => $description,
                    "subtitle" => $subtitle,
                    "expire_date" => $expire_date,
                ];
                $where =
                    "where id=" . $id . " and store_id=" . $vendor_id . "";
                $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);

                if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Coupon Update Successfully!!",
                        "message" => "Coupon section!",
                        "action" => "list_coupon.php",
                    ];
                } 
            
        } else {
            $table = "tbl_coupon";
            $field = [
                "status" => $status,
                "title" => $title,
                "coupon_code" => $coupon_code,
                "min_amt" => $min_amt,
                "coupon_val" => $coupon_val,
                "description" => $description,
                "subtitle" => $subtitle,
                "expire_date" => $expire_date,
            ];
            $where = "where id=" . $id . " and store_id=" . $vendor_id . "";
            $h = new Medico();
            $check = $h->mediupdateData($field, $table, $where);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Coupon Update Successfully!!",
                    "message" => "Coupon section!",
                    "action" => "list_coupon.php",
                ];
            } 
        }
    } elseif ($_POST["type"] == "add_partner") {
        $email = $_POST["email"];
        $vendor_id = $sdata["id"];
        $status = $_POST["status"];
        $ccode = $_POST["ccode"];
        $mobile = $_POST["mobile"];
        $password = $medi->real_escape_string($_POST["password"]);
        $title = $medi->real_escape_string($_POST["title"]);
        $target_dir = dirname(dirname(__FILE__)) . "/images/partner/";
        $url = "images/partner/";
        $temp = explode(".", $_FILES["cat_img"]["name"]);
        $newfilename = round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);
        
            $check_email = $medi->query(
                "select * from tbl_partner where email='" . $email . "'"
            )->num_rows;
            if ($check_email != 0) {
                $returnArr = [
                    "ResponseCode" => "401",
                    "Result" => "false",
                    "title" => "Email Address Already Used!!",
                    "message" => "Exist Problem!",
                    "action" => "list_Partner.php",
                ];
            } else {
                $timestamp = date("Y-m-d");
                move_uploaded_file(
                    $_FILES["cat_img"]["tmp_name"],
                    $target_file
                );
                $table = "tbl_partner";
                $field_values = [
                    "img",
                    "status",
                    "title",
                    "vendor_id",
                    "email",
                    "ccode",
                    "mobile",
                    "password",
                    "rdate",
                ];
                $data_values = [
                    "$url",
                    "$status",
                    "$title",
                    "$vendor_id",
                    "$email",
                    "$ccode",
                    "$mobile",
                    "$password",
                    "$timestamp",
                ];

                $h = new Medico();
                $check = $h->mediinsertdata(
                    $field_values,
                    $data_values,
                    $table
                );
                if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Partner Add Successfully!!",
                        "message" => "Partner section!",
                        "action" => "list_Partner.php",
                    ];
                } 
            }
        
    } elseif ($_POST["type"] == "edit_partner") {
        $email = $_POST["email"];
        $vendor_id = $sdata["id"];
        $status = $_POST["status"];
        $ccode = $_POST["ccode"];
        $mobile = $_POST["mobile"];
        $id = $_POST["id"];
        $password = $medi->real_escape_string($_POST["password"]);
        $title = $medi->real_escape_string($_POST["title"]);
        $target_dir = dirname(dirname(__FILE__)) . "/images/partner/";
        $url = "images/partner/";
        $temp = explode(".", $_FILES["cat_img"]["name"]);
        $newfilename = round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);
        $check_email = $medi->query(
            "select * from tbl_partner where email='" .
                $email .
                "' and id!=" .
                $id .
                ""
        )->num_rows;
        if ($check_email != 0) {
            $returnArr = [
                "ResponseCode" => "401",
                "Result" => "false",
                "title" => "Email Address Already Used!!",
                "message" => "Exist Problem!",
                "action" => "list_Partner.php",
            ];
        } else {
            if ($_FILES["cat_img"]["name"] != "") {
                
                    move_uploaded_file(
                        $_FILES["cat_img"]["tmp_name"],
                        $target_file
                    );
                    $table = "tbl_partner";
                    $field = [
                        "status" => $status,
                        "img" => $url,
                        "title" => $title,
                        "email" => $email,
                        "ccode" => $ccode,
                        "mobile" => $mobile,
                        "password" => $password,
                    ];
                    $where =
                        "where id=" . $id . " and vendor_id=" . $vendor_id . "";
                    $h = new Medico();
                    $check = $h->mediupdateData($field, $table, $where);

                    if ($check == 1) {
                        $returnArr = [
                            "ResponseCode" => "200",
                            "Result" => "true",
                            "title" => "Partner Update Successfully!!",
                            "message" => "Partner section!",
                            "action" => "list_Partner.php",
                        ];
                    } 
                
            } else {
                $table = "tbl_partner";
                $field = [
                    "status" => $status,
                    "title" => $title,
                    "email" => $email,
                    "ccode" => $ccode,
                    "mobile" => $mobile,
                    "password" => $password,
                ];
                $where =
                    "where id=" . $id . " and vendor_id=" . $vendor_id . "";
                $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);
                if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Partner Update Successfully!!",
                        "message" => "Partner section!",
                        "action" => "list_Partner.php",
                    ];
                } 
            }
        }
    } elseif ($_POST["type"] == "edit_category") {
        $okey = $_POST["status"];
        $id = $_POST["id"];
        $title = $medi->real_escape_string($_POST["title"]);
        $target_dir = dirname(dirname(__FILE__)) . "/images/category/";
        $url = "images/category/";
        $temp = explode(".", $_FILES["cat_img"]["name"]);
        $newfilename = round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);
		
		$target_dirs = dirname(dirname(__FILE__)) . "/images/category/";
        $urls = "images/category/";
        $temps = explode(".", $_FILES["cover_img"]["name"]);
        $newfilenames = uniqid().round(microtime(true)) . "." . end($temps);
        $target_files = $target_dirs . basename($newfilenames);
        $urls = $urls . basename($newfilenames);
		
        if ($_FILES["cat_img"]["name"] != "" and $_FILES["cover_img"]["name"] == "") {
           
                move_uploaded_file(
                    $_FILES["cat_img"]["tmp_name"],
                    $target_file
                );
                $table = "tbl_category";
                $field = ["status" => $okey, "img" => $url, "title" => $title];
                $where = "where id=" . $id . "";
                $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);

                if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Category Update Successfully!!",
                        "message" => "Category section!",
                        "action" => "list_category.php",
                    ];
                } 
            
        } else if ($_FILES["cat_img"]["name"] == "" and $_FILES["cover_img"]["name"] != "") {
            
                move_uploaded_file(
                    $_FILES["cover_img"]["tmp_name"],
                    $target_files
                );
                $table = "tbl_category";
                $field = ["status" => $okey, "cover" => $urls, "title" => $title];
                $where = "where id=" . $id . "";
                $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);

                if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Category Update Successfully!!",
                        "message" => "Category section!",
                        "action" => "list_category.php",
                    ];
                } 
            
        }else if ($_FILES["cat_img"]["name"] != "" and $_FILES["cover_img"]["name"] != "") {
            
                move_uploaded_file(
                    $_FILES["cat_img"]["tmp_name"],
                    $target_file
                );
				
				 move_uploaded_file(
                    $_FILES["cover_img"]["tmp_name"],
                    $target_files
                );
                $table = "tbl_category";
                $field = ["status" => $okey, "cover" => $urls,"img" => $url, "title" => $title];
                $where = "where id=" . $id . "";
                $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);

                if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Category Update Successfully!!",
                        "message" => "Category section!",
                        "action" => "list_category.php",
                    ];
                } 
            
        }else {
            $table = "tbl_category";
            $field = ["status" => $okey, "title" => $title];
            $where = "where id=" . $id . "";
            $h = new Medico();
            $check = $h->mediupdateData($field, $table, $where);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Category Update Successfully!!",
                    "message" => "Category section!",
                    "action" => "list_category.php",
                ];
            } 
        }
    } elseif ($_POST["type"] == "edit_mcat") {
        $okey = $_POST["status"];
        $id = $_POST["id"];
        $title = $medi->real_escape_string($_POST["title"]);
        
            $table = "tbl_mcat";
            $field = ["status" => $okey, "title" => $title];
            $where = "where id=" . $id . "";
            $h = new Medico();
            $check = $h->mediupdateData($field, $table, $where);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Menu Category Update Successfully!!",
                    "message" => "Menu Category section!",
                    "action" => "list_mcat.php",
                ];
            } 
        
    }elseif ($_POST["type"] == "edit_subcategory") {
        $cat_id = $_POST["cat_id"];
        $vendor_id = $sdata["id"];
        $okey = $_POST["status"];
        $id = $_POST["id"];
        $title = $medi->real_escape_string($_POST["title"]);
        $target_dir = dirname(dirname(__FILE__)) . "/images/subcategory/";
        $url = "images/subcategory/";
        $temp = explode(".", $_FILES["cat_img"]["name"]);
        $newfilename = round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);
        if ($_FILES["cat_img"]["name"] != "") {
            
                move_uploaded_file(
                    $_FILES["cat_img"]["tmp_name"],
                    $target_file
                );
                $table = "tbl_subcategory";
                $field = [
                    "status" => $okey,
                    "img" => $url,
                    "title" => $title,
                    "cat_id" => $cat_id,
                ];
                $where =
                    "where id=" . $id . " and vendor_id=" . $vendor_id . "";
                $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);

                if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Subcategory Update Successfully!!",
                        "message" => "Subcategory section!",
                        "action" => "list_Subcategory.php",
                    ];
                } 
            
        } else {
            $table = "tbl_subcategory";
            $field = [
                "status" => $okey,
                "title" => $title,
                "cat_id" => $cat_id,
            ];
            $where = "where id=" . $id . " and vendor_id=" . $vendor_id . "";
            $h = new Medico();
            $check = $h->mediupdateData($field, $table, $where);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Subcategory Update Successfully!!",
                    "message" => "Subcategory section!",
                    "action" => "list_Subcategory.php",
                ];
            } 
        }
    } elseif ($_POST["type"] == "edit_banner") {
        $okey = $_POST["status"];
        $id = $_POST["id"];
		$store_id = $_POST["store_id"];
        $target_dir = dirname(dirname(__FILE__)) . "/images/banner/";
        $url = "images/banner/";
        $temp = explode(".", $_FILES["cat_img"]["name"]);
        $newfilename = round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);
        if ($_FILES["cat_img"]["name"] != "") {
            
                move_uploaded_file(
                    $_FILES["cat_img"]["tmp_name"],
                    $target_file
                );
                $table = "banner";
                $field = ["status" => $okey, "img" => $url,"store_id"=>$store_id];
                $where = "where id=" . $id . "";
                $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);

                if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Banner Update Successfully!!",
                        "message" => "banner section!",
                        "action" => "list_banner.php",
                    ];
                } 
            
        } else {
            $table = "banner";
            $field = ["status" => $okey,"store_id"=>$store_id];
            $where = "where id=" . $id . "";
            $h = new Medico();
            $check = $h->mediupdateData($field, $table, $where);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Banner Update Successfully!!",
                    "message" => "banner section!",
                    "action" => "list_banner.php",
                ];
            } 
        }
    } elseif ($_POST["type"] == "edit_gallery") {
        $okey = $_POST["status"];
        $id = $_POST["id"];
		$store_id = $sdata["id"];
        $target_dir = dirname(dirname(__FILE__)) . "/images/gallery/";
        $url = "images/gallery/";
        $temp = explode(".", $_FILES["cat_img"]["name"]);
        $newfilename = round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);
        if ($_FILES["cat_img"]["name"] != "") {
            
                move_uploaded_file(
                    $_FILES["cat_img"]["tmp_name"],
                    $target_file
                );
                $table = "tbl_photo";
                $field = ["status" => $okey, "img" => $url];
                $where = "where id=" . $id . " and store_id=".$store_id."";
                $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);

                if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Photo Update Successfully!!",
                        "message" => "Photo section!",
                        "action" => "list_photo.php",
                    ];
                } 
            
        } else {
            $table = "tbl_photo";
            $field = ["status" => $okey];
            $where = "where id=" . $id . "";
            $h = new Medico();
            $check = $h->mediupdateData($field, $table, $where);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Photo Update Successfully!!",
                    "message" => "Photo section!",
                    "action" => "list_photo.php",
                ];
            } 
        }
    }elseif ($_POST["type"] == "edit_extra") {
        $okey = $_POST["status"];
        $id = $_POST["id"];
		$mid = $_POST["mid"];
		$store_id = $sdata["id"];
        $target_dir = dirname(dirname(__FILE__)) . "/images/gallery/";
        $url = "images/gallery/";
        $temp = explode(".", $_FILES["cat_img"]["name"]);
        $newfilename = uniqid().round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);
        if ($_FILES["cat_img"]["name"] != "") {
            
                move_uploaded_file(
                    $_FILES["cat_img"]["tmp_name"],
                    $target_file
                );
                $table = "tbl_extra";
                $field = ["status" => $okey, "img" => $url,"mid"=>$mid];
                $where = "where id=" . $id . " and store_id=".$store_id."";
                $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);

                if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Extra Image Update Successfully!!",
                        "message" => "Extra Image section!",
                        "action" => "list_extra.php",
                    ];
                } 
            
        } else {
            $table = "tbl_extra";
            $field = ["status" => $okey,"mid"=>$mid];
            $where = "where id=" . $id ." and store_id=".$store_id."";
            $h = new Medico();
            $check = $h->mediupdateData($field, $table, $where);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Extra Image Update Successfully!!",
                    "message" => "Extra Image section!",
                    "action" => "list_extra.php",
                ];
            } 
        }
    }elseif ($_POST["type"] == "add_zone") {
        $zname = $_POST["zname"];
        $okey = $_POST["status"];
        $coordinates = $_POST["coordinates"];
        foreach (
            explode("),(", trim($coordinates, "()"))
            as $index => $single_array
        ) {
            if ($index == 0) {
                $lastcord = explode(",", $single_array);
            }
            $coords = explode(",", $single_array);
            $polygon[] = new Point($coords[0], $coords[1]);
        }

        $polygon[] = new Point($lastcord[0], $lastcord[1]);
        $pv = new Polygon([new LineString($polygon)]);

        $table = "zones";
        $field_values = ["coordinates", "title", "status", "alias"];
        $data_values = [
            "ST_GeomFromText('POLYGON($pv)')",
            "$zname",
            "$okey",
            "$coordinates",
        ];

        $h = new Medico();
        $check = $h->medizoneinsertdata($field_values, $data_values, $table);
        if ($check == 1) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "true",
                "title" => "Zone Add Successfully!!",
                "message" => "Zone section!",
                "action" => "list_Zone.php",
            ];
        } 
    } elseif ($_POST["type"] == "edit_zone") {
        $zname = $_POST["zname"];
        $id = $_POST["id"];
        $okey = $_POST["status"];
        $coordinates = $_POST["coordinates"];

        foreach (
            explode("),(", trim($coordinates, "()"))
            as $index => $single_array
        ) {
            if ($index == 0) {
                $lastcord = explode(",", $single_array);
            }
            $coords = explode(",", $single_array);
            $polygon[] = new Point($coords[0], $coords[1]);
        }

        $polygon[] = new Point($lastcord[0], $lastcord[1]);
        $pv = new Polygon([new LineString($polygon)]);

        $table = "zones";
        $field = [
            "coordinates" => "ST_GeomFromText('POLYGON($pv)')",
            "title" => $zname,
            "status" => $okey,
            "alias" => $coordinates,
        ];
        $where = "where id=" . $id . "";
        $h = new Medico();
        $check = $h->medizoneupdateData($field, $table, $where);
        if ($check == 1) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "true",
                "title" => "Zone Update Successfully!!",
                "message" => "Zone section!",
                "action" => "list_Zone.php",
            ];
        } 
    } elseif ($_POST["type"] == "add_Store") {
        $cname = mysqli_real_escape_string($medi, $_POST["cname"]);
        $status = $_POST["status"];
		$is_pickup = $_POST["is_pickup"];
        $arate = $_POST["arate"];
		$pre_con = $_POST["pre_con"];
        $slogan = mysqli_real_escape_string($medi,$_POST["slogan"]);
		$opentime = $_POST["opentime"];
		$closetime = $_POST["closetime"];
		$cancle_policy = mysqli_real_escape_string($medi,$_POST["cancle_policy"]);
		$slogan_title = mysqli_real_escape_string($medi,$_POST["slogan_title"]);
		$cdesc = mysqli_real_escape_string($medi,$_POST["cdesc"]);
        $lcode = $_POST["lcode"];
        $mobile = $_POST["mobile"];
        $sdesc = $_POST["sdesc"];
        $catsearch = implode(",", $_POST["catsearch"]);
        $FullAddress = mysqli_real_escape_string(
            $medi,
            $_POST["FullAddress"]
        );
        $pincode = $_POST["pincode"];
        $landmark = mysqli_real_escape_string($medi, $_POST["landmark"]);
        $latitude = $_POST["latitude"];
        $longitude = $_POST["longitude"];
        $scharge = $_POST["scharge"];

        $charge_type = $_POST["charge_type"];
        $dcharge = empty($_POST["dcharge"]) ? 0 : $_POST["dcharge"];
        $ukms = empty($_POST["ukms"]) ? 0 : $_POST["ukms"];
        $uprice = empty($_POST["uprice"]) ? 0 : $_POST["uprice"];
        $aprice = empty($_POST["aprice"]) ? 0 : $_POST["aprice"];
        $morder = $_POST["morder"];
        $commission = $_POST["commission"];
        $bname = mysqli_real_escape_string($medi, $_POST["bname"]);
        $ifsc = $_POST["ifsc"];
        $rname = mysqli_real_escape_string($medi, $_POST["rname"]);
        $ano = $_POST["ano"];
        $paypal = $_POST["paypal"];
        $upi = $_POST["upi"];
        $email = $_POST["email"];
        $password = $_POST["password"];
        $zone_id = $_POST["zone_id"];

        $target_dir = dirname(dirname(__FILE__)) . "/images/store/";
        $url = "images/store/";
        $temp = explode(".", $_FILES["kit_img"]["name"]);
        $newfilename = round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);

        $target_dirs = dirname(dirname(__FILE__)) . "/images/store/";
        $urls = "images/store/";
        $temps = explode(".", $_FILES["cover_img"]["name"]);
        $newfilenames = uniqid() . round(microtime(true)) . "." . end($temps);
        $target_files = $target_dirs . basename($newfilenames);
        $urls = $urls . basename($newfilenames);

        $check_details = $medi->query(
            "select email from service_details where email='" . $email . "'"
        )->num_rows;
        if ($check_details != 0) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "false",
                "title" => "Store Email Already Used!!",
                "message" => "Store section!",
                "action" => "add_store.php",
            ];
        } else {
            
                move_uploaded_file(
                    $_FILES["kit_img"]["tmp_name"],
                    $target_file
                );
                move_uploaded_file(
                    $_FILES["cover_img"]["tmp_name"],
                    $target_files
                );
                $table = "service_details";
                $field_values = [
                    "sdesc",
                    "rimg",
                    "status",
                    "title",
                    "rate",
                    "slogan",
                    "lcode",
                    "catid",
                    "full_address",
					"slogan_title",
                    "pincode",
                    "landmark",
                    "lats",
                    "longs",
                    "store_charge",
                    "dcharge",
                    "morder",
                    "commission",
                    "bank_name",
                    "ifsc",
                    "receipt_name",
                    "acc_number",
                    "paypal_id",
                    "upi_id",
                    "email",
                    "password",
                    "mobile",
                    "charge_type",
                    "ukm",
                    "uprice",
                    "aprice",
                    "zone_id",
                    "cover_img",
					"cdesc",
					"cancle_policy",
					"opentime",
					"closetime",
					"is_pickup",
					"pre_con"
                ];
                $data_values = [
                    "$sdesc",
                    "$url",
                    "$status",
                    "$cname",
                    "$arate",
                    "$slogan",
                    "$lcode",
                    "$catsearch",
                    "$FullAddress",
					"$slogan_title",
                    "$pincode",
                    "$landmark",
                    "$latitude",
                    "$longitude",
                    "$scharge",
                    "$dcharge",
                    "$morder",
                    "$commission",
                    "$bname",
                    "$ifsc",
                    "$rname",
                    "$ano",
                    "$paypal",
                    "$upi",
                    "$email",
                    "$password",
                    "$mobile",
                    "$charge_type",
                    "$ukms",
                    "$uprice",
                    "$aprice",
                    "$zone_id",
                    "$urls",
					"$cdesc",
					"$cancle_policy",
					"$opentime",
					"$closetime",
					"$is_pickup",
					"$pre_con"
                ];
                $h = new Medico();
                $check = $h->mediinsertdata(
                    $field_values,
                    $data_values,
                    $table
                );
                if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Store Add Successfully!!",
                        "message" => "Store section!",
                        "action" => "list_store.php",
                    ];
                } 
            
        }
    } elseif ($_POST["type"] == "edit_Store") {
        $id = $_POST["id"];
        $cname = mysqli_real_escape_string($medi, $_POST["cname"]);
        $status = $_POST["status"];
        $arate = $_POST["arate"];
		$is_pickup = $_POST["is_pickup"];
        $slogan = mysqli_real_escape_string($medi,$_POST["slogan"]);
		$slogan_title = mysqli_real_escape_string($medi,$_POST["slogan_title"]);
		$cdesc = mysqli_real_escape_string($medi,$_POST["cdesc"]);
        $lcode = $_POST["lcode"];
        $mobile = $_POST["mobile"];
        $sdesc = $_POST["sdesc"];
$opentime = $_POST["opentime"];
$pre_con = $_POST["pre_con"];
		$closetime = $_POST["closetime"];
		$cancle_policy = mysqli_real_escape_string($medi,$_POST["cancle_policy"]);
        $catsearch = implode(",", $_POST["catsearch"]);
        $FullAddress = mysqli_real_escape_string(
            $medi,
            $_POST["FullAddress"]
        );
        $pincode = $_POST["pincode"];
        $landmark = mysqli_real_escape_string($medi, $_POST["landmark"]);
        $latitude = $_POST["latitude"];
        $longitude = $_POST["longitude"];
        $scharge = $_POST["scharge"];

        $charge_type = $_POST["charge_type"];
        $dcharge = empty($_POST["dcharge"]) ? 0 : $_POST["dcharge"];
        $ukms = empty($_POST["ukms"]) ? 0 : $_POST["ukms"];
        $uprice = empty($_POST["uprice"]) ? 0 : $_POST["uprice"];
        $aprice = empty($_POST["aprice"]) ? 0 : $_POST["aprice"];
        $morder = $_POST["morder"];
        $commission = $_POST["commission"];
        $bname = mysqli_real_escape_string($medi, $_POST["bname"]);
        $ifsc = $_POST["ifsc"];
        $rname = mysqli_real_escape_string($medi, $_POST["rname"]);
        $ano = $_POST["ano"];
        $paypal = $_POST["paypal"];
        $upi = $_POST["upi"];
        $email = $_POST["email"];
        $password = $_POST["password"];
        $zone_id = $_POST["zone_id"];

        $target_dir = dirname(dirname(__FILE__)) . "/images/store/";
        $url = "images/store/";
        $temp = explode(".", $_FILES["kit_img"]["name"]);
        $newfilename = round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);

        $target_dirs = dirname(dirname(__FILE__)) . "/images/store/";
        $urls = "images/store/";
        $temps = explode(".", $_FILES["cover_img"]["name"]);
        $newfilenames = uniqid() . round(microtime(true)) . "." . end($temps);
        $target_files = $target_dirs . basename($newfilenames);
        $urls = $urls . basename($newfilenames);

        $check_details = $medi->query(
            "select email from service_details where email='" .
                $email .
                "' and id!=" .
                $id .
                ""
        )->num_rows;
        if ($check_details != 0) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "false",
                "title" => "Store Email Already Used!!",
                "message" => "Store section!",
                "action" => "add_store.php?id=" . $id . "",
            ];
        } else {
            if (
                $_FILES["kit_img"]["name"] != "" and
                $_FILES["cover_img"]["name"] == ""
            ) {
                
                    move_uploaded_file(
                        $_FILES["kit_img"]["tmp_name"],
                        $target_file
                    );
                    $table = "service_details";
                    $field = [
                        "zone_id" => $zone_id,
                        "charge_type" => $charge_type,
                        "ukm" => $ukms,
                        "aprice" => $aprice,
                        "uprice" => $uprice,
                        "sdesc" => $sdesc,
                        "status" => $status,
                        "rimg" => $url,
                        "title" => $cname,
                        "rate" => $arate,
                        "slogan" => $slogan,
						"slogan_title"=>$slogan_title,
						"cdesc"=>$cdesc,
                        "lcode" => $lcode,
                        "catid" => $catsearch,
                        "full_address" => $FullAddress,
                        "pincode" => $pincode,
                        "landmark" => $landmark,
                        "lats" => $latitude,
                        "longs" => $longitude,
                        "store_charge" => $scharge,
                        "dcharge" => $dcharge,
                        "morder" => $morder,
                        "commission" => $commission,
                        "bank_name" => $bname,
                        "ifsc" => $ifsc,
                        "receipt_name" => $rname,
                        "acc_number" => $ano,
                        "paypal_id" => $paypal,
                        "upi_id" => $upi,
                        "email" => $email,
                        "password" => $password,
                        "mobile" => $mobile,
						"opentime"=>$opentime,
						"closetime"=>$closetime,
						"cancle_policy"=>$cancle_policy,
						"is_pickup"=>$is_pickup,
						"pre_con"=>$pre_con
                    ];
                    $where = "where id=" . $id . "";
                    $h = new Medico();
                    $check = $h->mediupdateData($field, $table, $where);

                    if ($check == 1) {
                        $returnArr = [
                            "ResponseCode" => "200",
                            "Result" => "true",
                            "title" => "Store Update Successfully!!",
                            "message" => "Store section!",
                            "action" => "list_store.php",
                        ];
                    } 
                
            } elseif (
                $_FILES["kit_img"]["name"] == "" and
                $_FILES["cover_img"]["name"] != ""
            ) {
                
                    move_uploaded_file(
                        $_FILES["cover_img"]["tmp_name"],
                        $target_files
                    );
                    $table = "service_details";
                    $field = [
                        "zone_id" => $zone_id,
                        "charge_type" => $charge_type,
                        "ukm" => $ukms,
                        "aprice" => $aprice,
                        "uprice" => $uprice,
                        "sdesc" => $sdesc,
                        "status" => $status,
                        "cover_img" => $urls,
                        "title" => $cname,
                        "rate" => $arate,
                        "slogan" => $slogan,
						"slogan_title"=>$slogan_title,
						"cdesc"=>$cdesc,
                        "lcode" => $lcode,
                        "catid" => $catsearch,
                        "full_address" => $FullAddress,
                        "pincode" => $pincode,
                        "landmark" => $landmark,
                        "lats" => $latitude,
                        "longs" => $longitude,
                        "store_charge" => $scharge,
                        "dcharge" => $dcharge,
                        "morder" => $morder,
                        "commission" => $commission,
                        "bank_name" => $bname,
                        "ifsc" => $ifsc,
                        "receipt_name" => $rname,
                        "acc_number" => $ano,
                        "paypal_id" => $paypal,
                        "upi_id" => $upi,
                        "email" => $email,
                        "password" => $password,
                        "mobile" => $mobile,
						"opentime"=>$opentime,
						"closetime"=>$closetime,
						"cancle_policy"=>$cancle_policy,
						"is_pickup"=>$is_pickup,
						"pre_con"=>$pre_con
                    ];
                    $where = "where id=" . $id . "";
                    $h = new Medico();
                    $check = $h->mediupdateData($field, $table, $where);

                    if ($check == 1) {
                        $returnArr = [
                            "ResponseCode" => "200",
                            "Result" => "true",
                            "title" => "Store Update Successfully!!",
                            "message" => "Store section!",
                            "action" => "list_store.php",
                        ];
                    } 
                
            } elseif (
                $_FILES["kit_img"]["name"] != "" and
                $_FILES["cover_img"]["name"] != ""
            ) {
                
                    move_uploaded_file(
                        $_FILES["cover_img"]["tmp_name"],
                        $target_files
                    );
                    move_uploaded_file(
                        $_FILES["kit_img"]["tmp_name"],
                        $target_file
                    );

                    $table = "service_details";
                    $field = [
                        "zone_id" => $zone_id,
                        "charge_type" => $charge_type,
                        "ukm" => $ukms,
                        "aprice" => $aprice,
                        "uprice" => $uprice,
                        "sdesc" => $sdesc,
                        "status" => $status,
                        "cover_img" => $urls,
                        "rimg" => $url,
                        "title" => $cname,
                        "rate" => $arate,
                        "slogan" => $slogan,
						"slogan_title"=>$slogan_title,
						"cdesc"=>$cdesc,
                        "lcode" => $lcode,
                        "catid" => $catsearch,
                        "full_address" => $FullAddress,
                        "pincode" => $pincode,
                        "landmark" => $landmark,
                        "lats" => $latitude,
                        "longs" => $longitude,
                        "store_charge" => $scharge,
                        "dcharge" => $dcharge,
                        "morder" => $morder,
                        "commission" => $commission,
                        "bank_name" => $bname,
                        "ifsc" => $ifsc,
                        "receipt_name" => $rname,
                        "acc_number" => $ano,
                        "paypal_id" => $paypal,
                        "upi_id" => $upi,
                        "email" => $email,
                        "password" => $password,
                        "mobile" => $mobile,
						"opentime"=>$opentime,
						"closetime"=>$closetime,
						"cancle_policy"=>$cancle_policy,
						"is_pickup"=>$is_pickup,
						"pre_con"=>$pre_con
                    ];
                    $where = "where id=" . $id . "";
                    $h = new Medico();
                    $check = $h->mediupdateData($field, $table, $where);

                    if ($check == 1) {
                        $returnArr = [
                            "ResponseCode" => "200",
                            "Result" => "true",
                            "title" => "Store Update Successfully!!",
                            "message" => "Store section!",
                            "action" => "list_store.php",
                        ];
                    } 
                
            } else {
                $table = "service_details";
                $field = [
                    "zone_id" => $zone_id,
                    "charge_type" => $charge_type,
                    "ukm" => $ukms,
                    "aprice" => $aprice,
                    "uprice" => $uprice,
                    "sdesc" => $sdesc,
                    "status" => $status,
                    "title" => $cname,
                    "rate" => $arate,
                    "slogan" => $slogan,
					"slogan_title"=>$slogan_title,
					"cdesc"=>$cdesc,
                    "lcode" => $lcode,
                    "catid" => $catsearch,
                    "full_address" => $FullAddress,
                    "pincode" => $pincode,
                    "landmark" => $landmark,
                    "lats" => $latitude,
                    "longs" => $longitude,
                    "store_charge" => $scharge,
                    "dcharge" => $dcharge,
                    "morder" => $morder,
                    "commission" => $commission,
                    "bank_name" => $bname,
                    "ifsc" => $ifsc,
                    "receipt_name" => $rname,
                    "acc_number" => $ano,
                    "paypal_id" => $paypal,
                    "upi_id" => $upi,
                    "email" => $email,
                    "password" => $password,
                    "mobile" => $mobile,
						"opentime"=>$opentime,
						"closetime"=>$closetime,
						"cancle_policy"=>$cancle_policy,
						"is_pickup"=>$is_pickup,
						"pre_con"=>$pre_con
                ];
                $where = "where id=" . $id . "";
                $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);

                if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Store Update Successfully!!",
                        "message" => "Store section!",
                        "action" => "list_store.php",
                    ];
                } 
            }
        }
    } elseif ($_POST["type"] == "edit_payment") {
        $dname = mysqli_real_escape_string($medi, $_POST["cname"]);
        $attributes = mysqli_real_escape_string($medi, $_POST["p_attr"]);
        $ptitle = mysqli_real_escape_string($medi, $_POST["ptitle"]);
        $okey = $_POST["status"];
        $id = $_POST["id"];
        $p_show = $_POST["p_show"];
        $target_dir = dirname(dirname(__FILE__)) . "/images/payment/";
        $url = "images/payment/";
        $temp = explode(".", $_FILES["cat_img"]["name"]);
        $newfilename = round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);
        if ($_FILES["cat_img"]["name"] != "") {
            
                move_uploaded_file(
                    $_FILES["cat_img"]["tmp_name"],
                    $target_file
                );
                $table = "tbl_payment_list";
                $field = [
                    "title" => $dname,
                    "status" => $okey,
                    "img" => $url,
                    "attributes" => $attributes,
                    "subtitle" => $ptitle,
                    "p_show" => $p_show,
                ];
                $where = "where id=" . $id . "";
                $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);

                if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Payment Gateway Update Successfully!!",
                        "message" => "Payment Gateway section!",
                        "action" => "payment_method.php",
                    ];
                } 
            
        } else {
            $table = "tbl_payment_list";
            $field = [
                "title" => $dname,
                "status" => $okey,
                "attributes" => $attributes,
                "subtitle" => $ptitle,
                "p_show" => $p_show,
            ];
            $where = "where id=" . $id . "";
            $h = new Medico();
            $check = $h->mediupdateData($field, $table, $where);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Payment Gateway Update Successfully!!",
                    "message" => "Payment Gateway section!",
                    "action" => "payment_method.php",
                ];
            } 
        }
    } elseif ($_POST["type"] == "add_faq") {
        $okey = $_POST["status"];
        $question = $medi->real_escape_string($_POST["question"]);
        $answer = $medi->real_escape_string($_POST["answer"]);
        $store_id = $sdata["id"];
        $table = "tbl_faq";
        $field_values = ["question", "answer", "status","store_id"];
        $data_values = ["$question", "$answer", "$okey","$store_id"];

        $h = new Medico();
        $check = $h->mediinsertdata($field_values, $data_values, $table);
        if ($check == 1) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "true",
                "title" => "FAQ Add Successfully!!",
                "message" => "FAQ section!",
                "action" => "list_faq.php",
            ];
        } 
    }elseif ($_POST["type"] == "add_time") {
        $okey = $_POST["status"];
        $mintime = $medi->real_escape_string($_POST["mintime"]);
        $maxtime = $medi->real_escape_string($_POST["maxtime"]);
        $store_id = $sdata["id"];
        $table = "tbl_time";
        $field_values = ["mintime", "maxtime", "status","store_id"];
        $data_values = ["$mintime", "$maxtime", "$okey","$store_id"];

        $h = new Medico();
        $check = $h->mediinsertdata($field_values, $data_values, $table);
        if ($check == 1) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "true",
                "title" => "Timeslot Add Successfully!!",
                "message" => "Timeslot section!",
                "action" => "list_time.php",
            ];
        } 
    } elseif ($_POST["type"] == "add_code") {
        $okey = $_POST["status"];
        $title = $medi->real_escape_string($_POST["title"]);

        $table = "tbl_code";
        $field_values = ["ccode", "status"];
        $data_values = ["$title", "$okey"];

        $h = new Medico();
        $check = $h->mediinsertdata($field_values, $data_values, $table);
        if ($check == 1) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "true",
                "title" => "Country Code Add Successfully!!",
                "message" => "Country Code section!",
                "action" => "list_country_code.php",
            ];
        } 
    } elseif ($_POST["type"] == "add_cover") {
        $cat_id = $_POST["cat_id"];
        $vendor_id = $sdata["id"];
        $status = $_POST["status"];
        $check_cover = $medi->query(
            "select * from tbl_cover where cat_id=" .
                $cat_id .
                " and vendor_id=" .
                $vendor_id .
                ""
        )->num_rows;
        if ($check_cover != 0) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "false",
                "title" => "Cover Category Already Added",
                "message" => "Exist  Probblem!!",
                "action" => "add_Cover.php",
            ];
        } else {
            $table = "tbl_cover";
            $field_values = ["cat_id", "vendor_id", "status"];
            $data_values = ["$cat_id", "$vendor_id", "$status"];

            $h = new Medico();
            $check = $h->mediinsertdata($field_values, $data_values, $table);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Country Code Add Successfully!!",
                    "message" => "Country Code section!",
                    "action" => "list_Cover.php",
                ];
            } 
        }
    } elseif ($_POST["type"] == "edit_cover") {
        $cat_id = $_POST["cat_id"];
        $vendor_id = $sdata["id"];
        $id = $_POST["id"];
        $status = $_POST["status"];
        $check_cover = $medi->query(
            "select * from tbl_cover where cat_id=" .
                $cat_id .
                " and vendor_id=" .
                $vendor_id .
                " and id!=" .
                $id .
                ""
        )->num_rows;
        if ($check_cover != 0) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "false",
                "title" => "Cover Category Already Added",
                "message" => "Exist  Probblem!!",
                "action" => "add_Cover.php",
            ];
        } else {
            $table = "tbl_cover";
            $field = ["cat_id" => $cat_id, "status" => $status];
            $where = "where id=" . $id . " and vendor_id=" . $vendor_id . "";
            $h = new Medico();
            $check = $h->mediupdateData($field, $table, $where);

            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Cover Update Successfully!!",
                    "message" => "Country Code section!",
                    "action" => "list_Cover.php",
                ];
            } 
        }
    } elseif ($_POST["type"] == "add_section") {
        $okey = $_POST["status"];
        $title = $medi->real_escape_string($_POST["title"]);
        $catsearch = $_POST["catsearch"];

        $table = "tbl_section";
        $field_values = ["title", "status", "cat_id"];
        $data_values = ["$title", "$okey", "$catsearch"];

        $h = new Medico();
        $check = $h->mediinsertdata($field_values, $data_values, $table);
        if ($check == 1) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "true",
                "title" => "Section  Add Successfully!!",
                "message" => "Section Operation!",
                "action" => "list_Section.php",
            ];
        } 
    } elseif ($_POST["type"] == "edit_section") {
        $okey = $_POST["status"];
        $title = $medi->real_escape_string($_POST["title"]);
        $catsearch = $_POST["catsearch"];
        $id = $_POST["id"];
        $table = "tbl_section";
        $field = ["status" => $okey, "title" => $title, "cat_id" => $catsearch];
        $where = "where id=" . $id . "";
        $h = new Medico();
        $check = $h->mediupdateData($field, $table, $where);
        if ($check == 1) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "true",
                "title" => "Section Update Successfully!!",
                "message" => "Section Operation!",
                "action" => "list_Section.php",
            ];
        } 
    } elseif ($_POST["type"] == "edit_faq") {
        $okey = $_POST["status"];
        $question = $medi->real_escape_string($_POST["question"]);
        $answer = $medi->real_escape_string($_POST["answer"]);
        $id = $_POST["id"];
        $table = "tbl_faq";
        $field = [
            "status" => $okey,
            "answer" => $answer,
            "question" => $question,
        ];
        $where = "where id=" . $id . "";
        $h = new Medico();
        $check = $h->mediupdateData($field, $table, $where);
        if ($check == 1) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "true",
                "title" => "FAQ Update Successfully!!",
                "message" => "FAQ Code section!",
                "action" => "list_faq.php",
            ];
        } 
    } 
	elseif ($_POST["type"] == "edit_time") {
        $okey = $_POST["status"];
        $mintime = $medi->real_escape_string($_POST["mintime"]);
        $maxtime = $medi->real_escape_string($_POST["maxtime"]);
        $id = $_POST["id"];
        $table = "tbl_time";
        $field = [
            "status" => $okey,
            "maxtime" => $maxtime,
            "mintime" => $mintime,
        ];
        $where = "where id=" . $id . "";
        $h = new Medico();
        $check = $h->mediupdateData($field, $table, $where);
        if ($check == 1) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "true",
                "title" => "Timeslot Update Successfully!!",
                "message" => "Timeslot Code section!",
                "action" => "list_time.php",
            ];
        } 
    }elseif ($_POST["type"] == "edit_code") {
        $okey = $_POST["status"];
        $title = $medi->real_escape_string($_POST["title"]);
        $id = $_POST["id"];
        $table = "tbl_code";
        $field = ["status" => $okey, "ccode" => $title];
        $where = "where id=" . $id . "";
        $h = new Medico();
        $check = $h->mediupdateData($field, $table, $where);
        if ($check == 1) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "true",
                "title" => "Country Code Update Successfully!!",
                "message" => "Country Code section!",
                "action" => "list_country_code.php",
            ];
        } 
    } elseif ($_POST["type"] == "code_delete") {
        $id = $_POST["id"];

        $table = "tbl_code";
        $where = "where id=" . $id . "";
        $h = new Medico();
        $check = $h->mediDeleteData($where, $table);
        if ($check == 1) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "true",
                "title" => "Country Code Delete Successfully!!",
                "message" => "Country Code section!",
                "action" => "list_country_code.php",
            ];
        } 
    } elseif ($_POST["type"] == "faq_delete") {
        $id = $_POST["id"];

        $table = "tbl_faq";
        $where = "where id=" . $id . "";
        $h = new Medico();
        $check = $h->mediDeleteData($where, $table);
        if ($check == 1) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "true",
                "title" => "FAQ Delete Successfully!!",
                "message" => "FAQ section!",
                "action" => "list_faq.php",
            ];
        } 
    } elseif ($_POST["type"] == "home_delete") {
        $id = $_POST["id"];

        $table = "tbl_section";
        $where = "where id=" . $id . "";
        $h = new Medico();
        $check = $h->mediDeleteData($where, $table);
        $table = "section_item";
        $where = "where section_id=" . $id . "";
        $h = new Medico();
        $h->mediDeleteData($where, $table);

        if ($check == 1) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "true",
                "title" => "Section Delete Successfully!!",
                "message" => "Section Operation!",
                "action" => "list_Section.php",
            ];
        } 
    } elseif ($_POST["type"] == "home_item_delete") {
        $id = $_POST["id"];

        $table = "section_item";
        $where = "where id=" . $id . "";
        $h = new Medico();
        $check = $h->mediDeleteData($where, $table);

        if ($check == 1) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "true",
                "title" => "Section Item Delete Successfully!!",
                "message" => "Section Item Operation!",
                "action" => "list_Section_Item.php",
            ];
        } 
    } elseif ($_POST["type"] == "add_page") {
        $ctitle = $medi->real_escape_string($_POST["ctitle"]);
        $cstatus = $_POST["cstatus"];
        $cdesc = $medi->real_escape_string($_POST["cdesc"]);
        $table = "tbl_page";

        $field_values = ["description", "status", "title"];
        $data_values = ["$cdesc", "$cstatus", "$ctitle"];

        $h = new Medico();
        $check = $h->mediinsertdata($field_values, $data_values, $table);
        if ($check == 1) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "true",
                "title" => "Page Add Successfully!!",
                "message" => "Page section!",
                "action" => "list_Page.php",
            ];
        } 
    } elseif ($_POST["type"] == "edit_page") {
        $id = $_POST["id"];
        $ctitle = $medi->real_escape_string($_POST["ctitle"]);
        $cstatus = $_POST["cstatus"];
        $cdesc = $medi->real_escape_string($_POST["cdesc"]);

        $table = "tbl_page";
        $field = [
            "description" => $cdesc,
            "status" => $cstatus,
            "title" => $ctitle,
        ];
        $where = "where id=" . $id . "";
        $h = new Medico();
        $check = $h->mediupdateData($field, $table, $where);
        if ($check == 1) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "true",
                "title" => "Page Update Successfully!!",
                "message" => "Page section!",
                "action" => "list_Page.php",
            ];
        } 
    } elseif ($_POST["type"] == "page_delete") {
        $id = $_POST["id"];

        $table = "tbl_page";
        $where = "where id=" . $id . "";
        $h = new Medico();
        $check = $h->mediDeleteData($where, $table);
        if ($check == 1) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "true",
                "title" => "Page Delete Successfully!!",
                "message" => "Page  section!",
                "action" => "list_Page.php",
            ];
        } 
    } elseif ($_POST["type"] == "edit_profile") {
        $dname = $_POST["email"];
        $dsname = $_POST["password"];
        $id = $_POST["id"];
        $table = "admin";
        $field = ["username" => $dname, "password" => $dsname];
        $where = "where id=" . $id . "";
        $h = new Medico();
        $check = $h->mediupdateData($field, $table, $where);
        if ($check == 1) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "true",
                "title" => "Profile Update Successfully!!",
                "message" => "Profile  section!",
                "action" => "profile.php",
            ];
        } 
    } elseif ($_POST["type"] == "edit_setting") {
        $webname = mysqli_real_escape_string($medi, $_POST["webname"]);
        $timezone = $_POST["timezone"];
        $currency = $_POST["currency"];
        $pstore = $_POST["pstore"];
        $pre_con = $_POST["pre_con"];
        $id = $_POST["id"];
		$map_key = $_POST["map_key"];
        $sms_type = $_POST['sms_type'];
			$auth_key = $_POST['auth_key'];
			$otp_id = $_POST['otp_id'];
			$acc_id = $_POST['acc_id'];
			$auth_token = $_POST['auth_token'];
			$twilio_number = $_POST['twilio_number'];
			$otp_auth = $_POST['otp_auth'];
        $one_key = $_POST["one_key"];

        $one_hash = $_POST["one_hash"];
        $s_key = $_POST["s_key"];

        $s_hash = $_POST["s_hash"];

        
        $d_key = $_POST["d_key"];
        $d_hash = $_POST["d_hash"];
        $scredit = $_POST["scredit"];
        $rcredit = $_POST["rcredit"];

        $target_dir = dirname(dirname(__FILE__)) . "/images/website/";
        $url = "images/website/";
        $temp = explode(".", $_FILES["weblogo"]["name"]);
        $newfilename = round(microtime(true)) . "." . end($temp);
        $target_file = $target_dir . basename($newfilename);
        $url = $url . basename($newfilename);
        if ($_FILES["weblogo"]["name"] != "") {
            
                move_uploaded_file(
                    $_FILES["weblogo"]["tmp_name"],
                    $target_file
                );
                $table = "tbl_setting";
                $field = [
                   
                    "timezone" => $timezone,
                    "weblogo" => $url,
                    "webname" => $webname,
                    "currency" => $currency,
                    "pstore" => $pstore,
                    "one_key" => $one_key,
                    "one_hash" => $one_hash,
                    "d_key" => $d_key,
                    "d_hash" => $d_hash,
                    "s_key" => $s_key,
                    "s_hash" => $s_hash,
                    "scredit" => $scredit,
                    "rcredit" => $rcredit,
					'otp_auth'=>$otp_auth,
					'twilio_number'=>$twilio_number,
					'auth_token'=>$auth_token,
					'acc_id'=>$acc_id,
					'otp_id'=>$otp_id,
					'auth_key'=>$auth_key,
					'sms_type'=>$sms_type,
					"pre_con"=>$pre_con,
					"map_key"=>$map_key
                ];
                $where = "where id=" . $id . "";
                $h = new Medico();
                $check = $h->mediupdateData($field, $table, $where);

                if ($check == 1) {
                    $returnArr = [
                        "ResponseCode" => "200",
                        "Result" => "true",
                        "title" => "Setting Update Successfully!!",
                        "message" => "Setting section!",
                        "action" => "setting.php",
                    ];
                } 
            
        } else {
            $table = "tbl_setting";
            $field = [
                
                "timezone" => $timezone,
                "webname" => $webname,
                "currency" => $currency,
                "pstore" => $pstore,
                "one_key" => $one_key,
                "one_hash" => $one_hash,
                "d_key" => $d_key,
                "d_hash" => $d_hash,
                "s_key" => $s_key,
                "s_hash" => $s_hash,
                "scredit" => $scredit,
                "rcredit" => $rcredit,
				'otp_auth'=>$otp_auth,
					'twilio_number'=>$twilio_number,
					'auth_token'=>$auth_token,
					'acc_id'=>$acc_id,
					'otp_id'=>$otp_id,
					'auth_key'=>$auth_key,
					'sms_type'=>$sms_type,
					"pre_con"=>$pre_con,
					"map_key"=>$map_key
            ];
            $where = "where id=" . $id . "";
            $h = new Medico();
            $check = $h->mediupdateData($field, $table, $where);
            if ($check == 1) {
                $returnArr = [
                    "ResponseCode" => "200",
                    "Result" => "true",
                    "title" => "Setting Update Successfully!!",
                    "message" => "Offer section!",
                    "action" => "setting.php",
                ];
            } 
        }
    } elseif ($_POST["type"] == "ban_delete") {
        $id = $_POST["id"];

        $table = "banner";
        $where = "where id=" . $id . "";
        $h = new Medico();
        $check = $h->mediDeleteData($where, $table);
        if ($check == 1) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "true",
                "title" => "Banner Delete Successfully!!",
                "message" => "banner section!",
                "action" => "list_banner.php",
            ];
        } 
    } elseif ($_POST["type"] == "subcat_delete") {
        $id = $_POST["id"];
        $vendor_id = $sdata["id"];
        $table = "tbl_subcategory";
        $where = "where id=" . $id . " and vendor_id=" . $vendor_id . "";
        $h = new Medico();
        $check = $h->mediDeleteData($where, $table);
        if ($check == 1) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "true",
                "title" => "Subcategory Delete Successfully!!",
                "message" => "Subcategory section!",
                "action" => "list_Subcategory.php",
            ];
        } 
    } elseif ($_POST["type"] == "cvimg_delete") {
        $id = $_POST["id"];
        $vendor_id = $sdata["id"];
        $table = "tbl_cover_images";
        $where = "where id=" . $id . "";
        $h = new Medico();
        $check = $h->mediDeleteData($where, $table);
        if ($check == 1) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "true",
                "title" => "Cover Image Delete Successfully!!",
                "message" => "Cover Image section!",
                "action" => "list_Cover.php",
            ];
        } 
    } elseif ($_POST["type"] == "service_delete") {
        $id = $_POST["id"];
        $vendor_id = $sdata["id"];
        $table = "tbl_service";
        $where = "where id=" . $id . " and vendor_id=" . $vendor_id . "";
        $h = new Medico();
        $check = $h->mediDeleteData($where, $table);
        if ($check == 1) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "true",
                "title" => "Service Delete Successfully!!",
                "message" => "Service section!",
                "action" => "list_Service.php",
            ];
        } 
    } elseif ($_POST["type"] == "zone_delete") {
        $id = $_POST["id"];

        $table = "zones";
        $where = "where id=" . $id . "";
        $h = new Medico();
        $check = $h->mediDeleteData($where, $table);
        if ($check == 1) {
            $returnArr = [
                "ResponseCode" => "200",
                "Result" => "true",
                "title" => "Delivery Zone Delete Successfully!!",
                "message" => "Delivery Zone section!",
                "action" => "list_Zone.php",
            ];
        } 
    }
}
echo json_encode($returnArr);
